/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.penalty;

import org.chocosolver.solver.constraints.nary.automata.penalty.IPenaltyFunction;
import org.chocosolver.solver.variables.IntVar;

public abstract class AbstractPenaltyFunction
implements IPenaltyFunction {
    @Override
    public abstract int penalty(int var1);

    @Override
    public double minGHat(double lambda, IntVar var) {
        double ghat = Double.POSITIVE_INFINITY;
        int ub = var.getUB();
        int i = var.getLB();
        while (i <= ub) {
            ghat = Math.min(ghat, (double)this.penalty(i) - lambda * (double)i);
            i = var.nextValue(i);
        }
        return ghat;
    }

    @Override
    public double maxGHat(double lambda, IntVar var) {
        double ghat = Double.NEGATIVE_INFINITY;
        int ub = var.getUB();
        int i = var.getLB();
        while (i <= ub) {
            ghat = Math.max(ghat, (double)this.penalty(i) - lambda * (double)i);
            i = var.nextValue(i);
        }
        return ghat;
    }
}

