/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.structure.regular;

import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.util.Set;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.regular.Arc;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableIntIterator;
import org.chocosolver.util.objects.StoredIndexedBipartiteSet;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;
import org.jgrapht.graph.DirectedMultigraph;

public class StoredDirectedMultiGraph {
    int[] starts;
    int[] offsets;
    TIntStack stack = new TIntArrayStack();
    StoredIndexedBipartiteSetWithOffset[] supports;
    public Nodes GNodes;
    public Arcs GArcs;

    public StoredDirectedMultiGraph(IEnvironment environment, DirectedMultigraph<Node, Arc> graph, int[] starts, int[] offsets, int supportLength) {
        this.starts = starts;
        this.offsets = offsets;
        this.GNodes = new Nodes();
        this.GArcs = new Arcs();
        TIntHashSet[] sups = new TIntHashSet[supportLength];
        this.supports = new StoredIndexedBipartiteSetWithOffset[supportLength];
        Set arcs = graph.edgeSet();
        this.GArcs.values = new int[arcs.size()];
        this.GArcs.dests = new int[arcs.size()];
        this.GArcs.origs = new int[arcs.size()];
        for (Arc a : arcs) {
            this.GArcs.values[a.id] = a.value;
            this.GArcs.dests[a.id] = a.dest.id;
            this.GArcs.origs[a.id] = a.orig.id;
            int idx = starts[a.orig.layer] + a.value - offsets[a.orig.layer];
            if (sups[idx] == null) {
                sups[idx] = new TIntHashSet();
            }
            sups[idx].add(a.id);
        }
        for (int i = 0; i < sups.length; ++i) {
            if (sups[i] == null) continue;
            this.supports[i] = new StoredIndexedBipartiteSetWithOffset(environment, sups[i].toArray());
        }
        Set nodes = graph.vertexSet();
        this.GNodes.outArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.inArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.layers = new int[nodes.size()];
        this.GNodes.states = new int[nodes.size()];
        for (Node n : nodes) {
            Set inarc;
            int i;
            this.GNodes.layers[n.id] = n.layer;
            this.GNodes.states[n.id] = n.state;
            Set outarc = graph.outgoingEdgesOf(n);
            if (!outarc.isEmpty()) {
                int[] out = new int[outarc.size()];
                i = 0;
                for (Arc a : outarc) {
                    out[i++] = a.id;
                }
                this.GNodes.outArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, out);
            }
            if ((inarc = graph.incomingEdgesOf(n)).isEmpty()) continue;
            int[] in = new int[inarc.size()];
            i = 0;
            for (Arc a : inarc) {
                in[i++] = a.id;
            }
            this.GNodes.inArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, in);
        }
    }

    public boolean hasSupport(int i, int j) {
        StoredIndexedBipartiteSetWithOffset sup = this.getSupport(i, j);
        return sup != null && !sup.isEmpty();
    }

    public void clearSupports(int idxVar, int val, Propagator p) throws ContradictionException {
        this.clearSupports(this.getSupport(idxVar, val), p);
    }

    private int getIdx(int i, int j) {
        return this.starts[i] + j - this.offsets[i];
    }

    protected final StoredIndexedBipartiteSetWithOffset getSupport(int i, int j) {
        return this.supports[this.getIdx(i, j)];
    }

    protected void removeArc(Propagator<IntVar> propagator) throws ContradictionException {
        while (this.stack.size() > 0) {
            int id;
            DisposableIntIterator it;
            StoredIndexedBipartiteSetWithOffset in;
            int arcId = this.stack.pop();
            int orig = this.GArcs.origs[arcId];
            int dest = this.GArcs.dests[arcId];
            int layer = this.GNodes.layers[orig];
            int value = this.GArcs.values[arcId];
            StoredIndexedBipartiteSetWithOffset support = this.getSupport(layer, value);
            support.remove(arcId);
            if (support.isEmpty()) {
                IntVar var = propagator.getVar(layer);
                try {
                    var.removeValue(value, propagator);
                }
                catch (ContradictionException ex) {
                    this.stack.clear();
                    throw ex;
                }
            }
            StoredIndexedBipartiteSetWithOffset out = this.GNodes.outArcs[orig];
            out.remove(arcId);
            if (this.GNodes.layers[orig] > 0 && out.isEmpty() && (in = this.GNodes.inArcs[orig]) != null) {
                it = in.getIterator();
                while (it.hasNext()) {
                    id = it.next();
                    this.stack.push(id);
                }
                it.dispose();
            }
            in = this.GNodes.inArcs[dest];
            in.remove(arcId);
            if (this.GNodes.layers[dest] >= propagator.getNbVars() || !in.isEmpty() || (out = this.GNodes.outArcs[dest]) == null) continue;
            it = out.getIterator();
            while (it.hasNext()) {
                id = it.next();
                this.stack.push(id);
            }
            it.dispose();
        }
    }

    protected void clearSupports(StoredIndexedBipartiteSet supports, Propagator p) throws ContradictionException {
        if (supports != null) {
            DisposableIntIterator it = supports.getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                this.stack.push(arcId);
            }
            it.dispose();
            this.removeArc(p);
        }
    }

    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        int nb = 0;
        for (i = 0; i < this.supports.length; ++i) {
            if (this.supports[i] == null || this.supports[i].isEmpty()) continue;
            ++nb;
        }
        st.append("nb: ").append(nb).append("\n");
        for (i = 0; i < this.supports.length; ++i) {
            if (this.supports[i] == null || this.supports[i].isEmpty()) continue;
            DisposableIntIterator it = this.supports[i].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                st.append(arcId).append(",");
            }
            it.dispose();
            st.append("\n");
        }
        return st.toString();
    }

    public class Arcs {
        int[] values;
        int[] dests;
        int[] origs;
    }

    class Nodes {
        int[] states;
        int[] layers;
        StoredIndexedBipartiteSetWithOffset[] outArcs;
        StoredIndexedBipartiteSetWithOffset[] inArcs;

        Nodes() {
        }
    }
}

