/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropEnumDomainChanneling
extends Propagator<IntVar> {
    protected final int n;
    protected final IntProcedure rem_proc;
    protected final IIntDeltaMonitor idm;
    protected final int offSet;

    public PropEnumDomainChanneling(BoolVar[] bvars, IntVar aVar, int offSet) {
        super((Variable[])ArrayUtils.append(bvars, {aVar}), PropagatorPriority.UNARY, true);
        assert (aVar.hasEnumeratedDomain());
        this.n = bvars.length;
        this.offSet = offSet;
        this.idm = ((IntVar[])this.vars)[this.n].monitorDelta(this);
        this.rem_proc = i -> ((IntVar[])this.vars)[i - offSet].instantiateTo(0, this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateLowerBound(this.offSet, this.aCause);
        ((IntVar[])this.vars)[this.n].updateUpperBound(this.n - 1 + this.offSet, this.aCause);
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                if (((IntVar[])this.vars)[i].getValue() == 0) {
                    ((IntVar[])this.vars)[this.n].removeValue(i + this.offSet, this.aCause);
                    continue;
                }
                ((IntVar[])this.vars)[this.n].instantiateTo(i + this.offSet, this.aCause);
                continue;
            }
            if (((IntVar[])this.vars)[this.n].contains(i + this.offSet)) continue;
            ((IntVar[])this.vars)[i].instantiateTo(0, this.aCause);
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            int v = ((IntVar[])this.vars)[this.n].getValue() - this.offSet;
            ((IntVar[])this.vars)[v].instantiateTo(1, this.aCause);
            for (int i = 0; i < this.n; ++i) {
                if (i == v) continue;
                ((IntVar[])this.vars)[i].instantiateTo(0, this.aCause);
            }
        }
        this.idm.unfreeze();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx == this.n) {
            this.idm.freeze();
            this.idm.forEachRemVal(this.rem_proc);
            this.idm.unfreeze();
        } else if (((IntVar[])this.vars)[varIdx].getValue() == 1) {
            ((IntVar[])this.vars)[this.n].instantiateTo(varIdx + this.offSet, this.aCause);
            for (int i = 0; i < this.n; ++i) {
                if (i == varIdx) continue;
                ((IntVar[])this.vars)[i].instantiateTo(0, this.aCause);
            }
        } else {
            ((IntVar[])this.vars)[this.n].removeValue(varIdx + this.offSet, this.aCause);
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            ((IntVar[])this.vars)[((IntVar[])this.vars)[this.n].getValue() - this.offSet].instantiateTo(1, this.aCause);
        }
    }

    @Override
    public ESat isEntailed() {
        int v;
        if (((IntVar[])this.vars)[this.n].getLB() > this.n - 1 + this.offSet || ((IntVar[])this.vars)[this.n].getUB() < this.offSet) {
            return ESat.FALSE;
        }
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated() || ((IntVar[])this.vars)[i].getValue() != 1 || ((IntVar[])this.vars)[this.n].contains(i + this.offSet)) continue;
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated() && !((IntVar[])this.vars)[v = ((IntVar[])this.vars)[this.n].getValue() - this.offSet].contains(1)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            BoolVar[] bVars = new BoolVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                bVars[i] = (BoolVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar aVar = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropEnumDomainChanneling(bVars, aVar, this.offSet));
        }
    }
}

