/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropInverseChannelAC
extends Propagator<IntVar> {
    protected int minX;
    protected int minY;
    protected int n;
    protected IntVar[] X;
    protected IntVar[] Y;
    protected RemProc rem_proc;
    protected IIntDeltaMonitor[] idms;

    public PropInverseChannelAC(IntVar[] X, IntVar[] Y, int minX, int minY) {
        super((Variable[])ArrayUtils.append(X, Y), PropagatorPriority.LINEAR, true);
        int i;
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i].hasEnumeratedDomain()) continue;
            throw new UnsupportedOperationException("this propagator should be used with enumerated domain variables");
        }
        this.X = (IntVar[])Arrays.copyOfRange(this.vars, 0, X.length);
        this.Y = (IntVar[])Arrays.copyOfRange(this.vars, X.length, ((IntVar[])this.vars).length);
        this.n = Y.length;
        this.minX = minX;
        this.minY = minY;
        this.rem_proc = new RemProc();
        this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].monitorDelta(this);
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.X[i].updateLowerBound(this.minX, this.aCause);
            this.X[i].updateUpperBound(this.n - 1 + this.minX, this.aCause);
            this.Y[i].updateLowerBound(this.minY, this.aCause);
            this.Y[i].updateUpperBound(this.n - 1 + this.minY, this.aCause);
        }
        for (i = 0; i < this.n; ++i) {
            this.enumeratedFilteringOfX(i);
            this.enumeratedFilteringOfY(i);
        }
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.idms[varIdx].freeze();
        this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
        this.idms[varIdx].unfreeze();
    }

    private void enumeratedFilteringOfX(int var) throws ContradictionException {
        int min = this.X[var].getLB();
        int max = this.X[var].getUB();
        int v = min;
        while (v <= max) {
            if (!this.Y[v - this.minX].contains(var + this.minY)) {
                this.X[var].removeValue(v, this.aCause);
            }
            v = this.X[var].nextValue(v);
        }
    }

    private void enumeratedFilteringOfY(int var) throws ContradictionException {
        int min = this.Y[var].getLB();
        int max = this.Y[var].getUB();
        int v = min;
        while (v <= max) {
            if (!this.X[v - this.minY].contains(var + this.minX)) {
                this.Y[var].removeValue(v, this.aCause);
            }
            v = this.Y[var].nextValue(v);
        }
    }

    @Override
    public ESat isEntailed() {
        boolean allInst = true;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated() || !((IntVar[])this.vars)[i + this.n].isInstantiated()) {
                allInst = false;
            }
            if (this.X[i].isInstantiated() && !this.Y[this.X[i].getValue() - this.minX].contains(i + this.minY)) {
                return ESat.FALSE;
            }
            if (!this.Y[i].isInstantiated() || this.X[this.Y[i].getValue() - this.minY].contains(i + this.minX)) continue;
            return ESat.FALSE;
        }
        if (allInst) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "Inverse_AC({" + this.X[0] + "...}{" + this.Y[0] + "...})";
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.n;
            IntVar[] X = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                X[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            IntVar[] Y = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i + this.n].duplicate(solver, identitymap);
                Y[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + this.n]);
            }
            identitymap.put(this, new PropInverseChannelAC(X, Y, this.minX, this.minY));
        }
    }

    private class RemProc
    implements UnaryIntProcedure<Integer> {
        private int var;

        private RemProc() {
        }

        @Override
        public UnaryIntProcedure set(Integer idxVar) {
            this.var = idxVar;
            return this;
        }

        @Override
        public void execute(int val) throws ContradictionException {
            if (this.var < PropInverseChannelAC.this.n) {
                PropInverseChannelAC.this.Y[val - PropInverseChannelAC.this.minX].removeValue(this.var + PropInverseChannelAC.this.minY, PropInverseChannelAC.this.aCause);
            } else {
                PropInverseChannelAC.this.X[val - PropInverseChannelAC.this.minY].removeValue(this.var - PropInverseChannelAC.this.n + PropInverseChannelAC.this.minX, PropInverseChannelAC.this.aCause);
            }
        }
    }
}

