/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.BitSet;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropInverseChannelBC
extends Propagator<IntVar> {
    protected int minX;
    protected int minY;
    protected int n;
    protected IntVar[] X;
    protected IntVar[] Y;
    protected BitSet toCompute;

    public PropInverseChannelBC(IntVar[] X, IntVar[] Y, int minX, int minY) {
        super((Variable[])ArrayUtils.append(X, Y), PropagatorPriority.LINEAR, true);
        this.X = (IntVar[])Arrays.copyOfRange(this.vars, 0, X.length);
        this.Y = (IntVar[])Arrays.copyOfRange(this.vars, X.length, ((IntVar[])this.vars).length);
        this.n = Y.length;
        this.minX = minX;
        this.minY = minY;
        this.toCompute = new BitSet(2 * this.n);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            for (i = 0; i < this.n; ++i) {
                this.X[i].updateLowerBound(this.minX, this.aCause);
                this.X[i].updateUpperBound(this.n - 1 + this.minX, this.aCause);
                this.Y[i].updateLowerBound(this.minY, this.aCause);
                this.Y[i].updateUpperBound(this.n - 1 + this.minY, this.aCause);
            }
            this.toCompute.clear();
            for (i = 0; i < this.n; ++i) {
                this.boundedFilteringOfX(i);
                this.boundedFilteringOfY(i);
            }
        }
        while (!this.toCompute.isEmpty()) {
            int next = this.toCompute.nextSetBit(0);
            this.toCompute.clear(next);
            if (next < this.n) {
                this.boundedFilteringOfX(next);
                continue;
            }
            this.boundedFilteringOfY(next - this.n);
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx < this.n) {
            this.boundedFilteringOfX(varIdx);
        } else {
            this.boundedFilteringOfY(varIdx - this.n);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    private void boundedFilteringOfX(int var) throws ContradictionException {
        int min = this.X[var].getLB();
        int max = this.X[var].getUB();
        int v = min;
        while (v <= max && !this.Y[v - this.minX].contains(var + this.minY)) {
            this.X[var].removeValue(v, this.aCause);
            this.toCompute.set(v - this.minX);
            v = this.X[var].nextValue(v);
        }
        v = max;
        while (v >= min && !this.Y[v - this.minX].contains(var + this.minY)) {
            this.X[var].removeValue(v, this.aCause);
            this.toCompute.set(v - this.minX);
            v = this.X[var].previousValue(v);
        }
    }

    private void boundedFilteringOfY(int var) throws ContradictionException {
        int min = this.Y[var].getLB();
        int max = this.Y[var].getUB();
        int v = min;
        while (v <= max && !this.X[v - this.minY].contains(var + this.minX)) {
            this.Y[var].removeValue(v, this.aCause);
            this.toCompute.set(v - this.minY);
            v = this.Y[var].nextValue(v);
        }
        v = max;
        while (v >= min && !this.X[v - this.minY].contains(var + this.minX)) {
            this.Y[var].removeValue(v, this.aCause);
            this.toCompute.set(v - this.minY);
            v = this.Y[var].previousValue(v);
        }
    }

    @Override
    public ESat isEntailed() {
        boolean allInst = true;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated() || !((IntVar[])this.vars)[i + this.n].isInstantiated()) {
                allInst = false;
            }
            if (this.X[i].isInstantiated() && !this.Y[this.X[i].getValue() - this.minX].contains(i + this.minY)) {
                return ESat.FALSE;
            }
            if (!this.Y[i].isInstantiated() || this.X[this.Y[i].getValue() - this.minY].contains(i + this.minX)) continue;
            return ESat.FALSE;
        }
        if (allInst) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "Inverse_BC({" + this.X[0] + "...}{" + this.Y[0] + "...})";
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.n;
            IntVar[] X = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                X[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            IntVar[] Y = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i + this.n].duplicate(solver, identitymap);
                Y[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + this.n]);
            }
            identitymap.put(this, new PropInverseChannelBC(X, Y, this.minX, this.minY));
        }
    }
}

