/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.map.hash.THashMap;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropCircuitSCC
extends Propagator<IntVar> {
    private int n;
    private int n2;
    private DirectedGraph support;
    private StrongConnectivityFinder SCCfinder;
    private DirectedGraph G_R;
    private int[] sccOf;
    private ISet[] mates;
    private Random rd;
    private int offSet;
    private CircuitConf conf;

    public PropCircuitSCC(IntVar[] succs, int offSet, CircuitConf conf) {
        super((Variable[])succs, PropagatorPriority.LINEAR, false);
        this.offSet = offSet;
        this.n = ((IntVar[])this.vars).length;
        this.n2 = this.n + 1;
        this.support = new DirectedGraph(this.n2, SetType.BITSET, true);
        this.G_R = new DirectedGraph(this.n2, SetType.LINKED_LIST, false);
        this.SCCfinder = new StrongConnectivityFinder(this.support);
        this.mates = new ISet[this.n2];
        for (int i = 0; i < this.n2; ++i) {
            this.mates[i] = SetFactory.makeLinkedList(false);
        }
        this.conf = conf;
        if (conf == CircuitConf.RD) {
            this.rd = new Random(0L);
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateLowerBound(this.offSet, this.aCause);
                ((IntVar[])this.vars)[i].updateUpperBound(this.n - 1 + this.offSet, this.aCause);
            }
        }
        switch (this.conf) {
            case FIRST: {
                this.filterFromSource(0);
                break;
            }
            case RD: {
                this.filterFromSource(this.rd.nextInt(this.n));
                break;
            }
            case ALL: {
                for (i = 0; i < this.n; ++i) {
                    this.filterFromSource(i);
                }
                break;
            }
        }
    }

    public void filterFromSource(int source) throws ContradictionException {
        int i;
        this.rebuild(source);
        int first = -1;
        int last = -1;
        int n_R = this.SCCfinder.getNbSCC();
        for (i = 0; i < n_R; ++i) {
            if (this.G_R.getPredOf(i).isEmpty()) {
                if (first != -1) {
                    this.contradiction(((IntVar[])this.vars)[0], "");
                }
                first = i;
            }
            if (!this.G_R.getSuccOf(i).isEmpty()) continue;
            if (last != -1) {
                this.contradiction(((IntVar[])this.vars)[0], "");
            }
            last = i;
        }
        if (first == -1 || last == -1 || first == last) {
            this.contradiction(((IntVar[])this.vars)[0], "");
        }
        if (this.visit(first, last, source) != n_R) {
            this.contradiction(((IntVar[])this.vars)[0], "");
        }
        this.filterFromInst(source);
        for (i = 0; i < n_R; ++i) {
            this.checkSCCLink(i);
        }
    }

    public void rebuild(int source) {
        int j;
        int i;
        for (i = 0; i < this.n2; ++i) {
            this.mates[i].clear();
            this.support.getSuccOf(i).clear();
            this.support.getPredOf(i).clear();
            this.G_R.getPredOf(i).clear();
            this.G_R.getSuccOf(i).clear();
        }
        this.G_R.getNodes().clear();
        for (i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int lb = v.getLB();
            int ub = v.getUB();
            j = lb;
            while (j <= ub) {
                if (j - this.offSet == source) {
                    this.support.addArc(i, this.n);
                } else {
                    this.support.addArc(i, j - this.offSet);
                }
                j = v.nextValue(j);
            }
        }
        this.SCCfinder.findAllSCC();
        int n_R = this.SCCfinder.getNbSCC();
        for (int i2 = 0; i2 < n_R; ++i2) {
            this.G_R.getNodes().add(i2);
        }
        this.sccOf = this.SCCfinder.getNodesSCC();
        for (int i3 = 0; i3 < this.n; ++i3) {
            int x = this.sccOf[i3];
            ISet succs = this.support.getSuccOf(i3);
            j = succs.getFirstElement();
            while (j >= 0) {
                if (x != this.sccOf[j]) {
                    this.G_R.addArc(x, this.sccOf[j]);
                    this.mates[x].add((i3 + 1) * this.n2 + j);
                }
                j = succs.getNextElement();
            }
        }
    }

    private int visit(int node, int last, int source) throws ContradictionException {
        if (node == -1) {
            this.contradiction(((IntVar[])this.vars)[0], "G_R disconnected");
        }
        if (node == last) {
            return 1;
        }
        int next = -1;
        ISet succs = this.G_R.getSuccOf(node);
        int x = succs.getFirstElement();
        while (x >= 0) {
            if (this.G_R.getPredOf(x).getSize() == 1) {
                if (next != -1) {
                    return 0;
                }
                next = x;
            } else {
                this.G_R.removeArc(node, x);
            }
            x = succs.getNextElement();
        }
        succs = this.mates[node];
        int e = succs.getFirstElement();
        while (e >= 0) {
            int to = e % this.n2;
            if (this.sccOf[to] != next) {
                int from = e / this.n2 - 1;
                if (to == this.n) {
                    to = source;
                }
                ((IntVar[])this.vars)[from].removeValue(to + this.offSet, this.aCause);
                this.mates[node].remove(e);
            }
            e = succs.getNextElement();
        }
        return this.visit(next, last, source) + 1;
    }

    private void filterFromInst(int source) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            int to = ((IntVar[])this.vars)[i].getValue() - this.offSet;
            int x = this.sccOf[i];
            if (to == source) {
                to = this.n;
            }
            if (to == -1 || this.sccOf[to] == x || this.mates[x].getSize() <= 1) continue;
            int arc = (i + 1) * this.n2 + to;
            int a = this.mates[x].getFirstElement();
            while (a >= 0) {
                if (a != arc) {
                    int val = a % this.n2;
                    if (val == this.n) {
                        val = source;
                    }
                    ((IntVar[])this.vars)[a / this.n2 - 1].removeValue(val + this.offSet, this.aCause);
                }
                a = this.mates[x].getNextElement();
            }
            this.mates[x].clear();
            this.mates[x].add(arc);
        }
    }

    private void checkSCCLink(int sccFrom) throws ContradictionException {
        int inDoor = -1;
        int outDoor = -1;
        int i = this.mates[sccFrom].getFirstElement();
        while (i >= 0) {
            if (inDoor == -1) {
                inDoor = i % this.n2;
            } else if (inDoor != i % this.n2) {
                inDoor = -2;
            }
            if (outDoor == -1) {
                outDoor = i / this.n2 - 1;
            } else if (outDoor != i / this.n2 - 1) {
                outDoor = -2;
            }
            i = this.mates[sccFrom].getNextElement();
        }
        if (inDoor >= 0) {
            this.forceInDoor(inDoor);
        }
        if (outDoor >= 0) {
            this.forceOutDoor(outDoor);
            int p = this.G_R.getPredOf(sccFrom).getFirstElement();
            if (p != -1) {
                int in = -1;
                int i2 = this.mates[p].getFirstElement();
                while (i2 >= 0) {
                    if (in == -1) {
                        in = i2 % this.n2;
                    } else if (in != i2 % this.n2) {
                        return;
                    }
                    i2 = this.mates[p].getNextElement();
                }
                assert (in != -1);
                assert (this.sccOf[in] == sccFrom);
                if (((IntVar[])this.vars)[in].contains(outDoor + this.offSet)) {
                    int size;
                    int i3 = this.SCCfinder.getSCCFirstNode(sccFrom);
                    for (size = 0; i3 >= 0 && size < 3; ++size) {
                        i3 = this.SCCfinder.getNextNode(i3);
                    }
                    if (size > 2) {
                        ((IntVar[])this.vars)[in].removeValue(outDoor + this.offSet, this.aCause);
                    }
                }
            }
        }
    }

    private void forceInDoor(int x) throws ContradictionException {
        int sx = this.sccOf[x];
        for (int i = 0; i < this.n; ++i) {
            if (this.sccOf[i] != sx) continue;
            ((IntVar[])this.vars)[i].removeValue(x + this.offSet, this.aCause);
        }
    }

    private void forceOutDoor(int x) throws ContradictionException {
        int sx = this.sccOf[x];
        int lb = ((IntVar[])this.vars)[x].getLB();
        int ub = ((IntVar[])this.vars)[x].getUB();
        int v = lb;
        while (v <= ub) {
            if (this.sccOf[v - this.offSet] == sx) {
                ((IntVar[])this.vars)[x].removeValue(v, this.aCause);
            }
            v = ((IntVar[])this.vars)[x].nextValue(v);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropCircuitSCC(aVars, this.offSet, this.conf));
        }
    }
}

