/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuit_ArboFiltering;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;

public class PropCircuit_AntiArboFiltering
extends PropCircuit_ArboFiltering {
    public PropCircuit_AntiArboFiltering(IntVar[] succs, int offSet, CircuitConf conf) {
        super(succs, offSet, conf);
    }

    @Override
    protected void filterFromDom(int duplicatedNode) throws ContradictionException {
        int y;
        int ub;
        int i;
        for (i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccOf(i).clear();
            this.connectedGraph.getPredOf(i).clear();
        }
        for (i = 0; i < this.n; ++i) {
            ub = ((IntVar[])this.vars)[i].getUB();
            y = ((IntVar[])this.vars)[i].getLB();
            while (y <= ub) {
                if (y - this.offSet == duplicatedNode) {
                    this.connectedGraph.addArc(this.n, i);
                } else {
                    this.connectedGraph.addArc(y - this.offSet, i);
                }
                y = ((IntVar[])this.vars)[i].nextValue(y);
            }
        }
        if (this.domFinder.findDominators()) {
            for (int x = 0; x < this.n; ++x) {
                ub = ((IntVar[])this.vars)[x].getUB();
                y = ((IntVar[])this.vars)[x].getLB();
                while (y <= ub) {
                    if (y - this.offSet != duplicatedNode && this.domFinder.isDomminatedBy(y - this.offSet, x)) {
                        if (x == duplicatedNode) {
                            throw new UnsupportedOperationException();
                        }
                        ((IntVar[])this.vars)[x].removeValue(y, this.aCause);
                    }
                    y = ((IntVar[])this.vars)[x].nextValue(y);
                }
            }
        } else {
            this.contradiction(((IntVar[])this.vars)[0], "the source cannot reach all nodes");
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropCircuit_AntiArboFiltering(aVars, this.offSet, this.conf));
        }
    }
}

