/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropSubCircuitSCC
extends Propagator<IntVar> {
    private int n;
    private int n2;
    private DirectedGraph support;
    private StrongConnectivityFinder SCCfinder;
    private DirectedGraph G_R;
    private int[] sccOf;
    private ISet[] mates;
    private Random rd;
    private int offSet;
    private BitSet mandSCC;
    private int[] possibleSources;

    public PropSubCircuitSCC(IntVar[] succs, int offSet) {
        super((Variable[])succs, PropagatorPriority.LINEAR, false);
        this.offSet = offSet;
        this.n = ((IntVar[])this.vars).length;
        this.n2 = this.n + 1;
        this.support = new DirectedGraph(this.n2, SetType.LINKED_LIST, true);
        this.G_R = new DirectedGraph(this.n2, SetType.LINKED_LIST, false);
        this.SCCfinder = new StrongConnectivityFinder(this.support);
        this.mates = new ISet[this.n2];
        for (int i = 0; i < this.n2; ++i) {
            this.mates[i] = SetFactory.makeLinkedList(false);
        }
        this.rd = new Random(0L);
        this.mandSCC = new BitSet(this.n2);
        this.possibleSources = new int[this.n];
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateLowerBound(this.offSet, this.aCause);
                ((IntVar[])this.vars)[i].updateUpperBound(this.n - 1 + this.offSet, this.aCause);
            }
        }
        int size = 0;
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
            this.possibleSources[size++] = i;
        }
        if (size > 0) {
            this.filterFromSource(this.possibleSources[this.rd.nextInt(size)]);
        }
    }

    public void filterFromSource(int source) throws ContradictionException {
        assert (!((IntVar[])this.vars)[source].contains(source + this.offSet));
        this.rebuild(source);
        int first = this.sccOf[source];
        int last = this.sccOf[this.n];
        int n_R = this.SCCfinder.getNbSCC();
        for (int i = 0; i < n_R; ++i) {
            if (i != first && this.G_R.getPredOf(i).isEmpty()) {
                this.makeLoops(source, i, false);
                continue;
            }
            if (i == last || !this.G_R.getSuccOf(i).isEmpty()) continue;
            this.makeLoops(source, i, true);
        }
        this.filterFromInst(source);
        this.checkSCCLink();
    }

    public void rebuild(int source) {
        int j;
        int i;
        this.mandSCC.clear();
        for (i = 0; i < this.n2; ++i) {
            this.mates[i].clear();
            this.support.getSuccOf(i).clear();
            this.support.getPredOf(i).clear();
            this.G_R.getPredOf(i).clear();
            this.G_R.getSuccOf(i).clear();
        }
        this.G_R.getNodes().clear();
        for (i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int lb = v.getLB();
            int ub = v.getUB();
            j = lb;
            while (j <= ub) {
                if (j - this.offSet == source) {
                    this.support.addArc(i, this.n);
                } else {
                    this.support.addArc(i, j - this.offSet);
                }
                j = v.nextValue(j);
            }
        }
        this.SCCfinder.findAllSCC();
        int n_R = this.SCCfinder.getNbSCC();
        for (int i2 = 0; i2 < n_R; ++i2) {
            this.G_R.getNodes().add(i2);
        }
        this.sccOf = this.SCCfinder.getNodesSCC();
        for (int i3 = 0; i3 < this.n; ++i3) {
            int x = this.sccOf[i3];
            if (!((IntVar[])this.vars)[i3].contains(i3 + this.offSet)) {
                this.mandSCC.set(x);
            }
            ISet succs = this.support.getSuccOf(i3);
            j = succs.getFirstElement();
            while (j >= 0) {
                if (x != this.sccOf[j]) {
                    this.G_R.addArc(x, this.sccOf[j]);
                    this.mates[x].add((i3 + 1) * this.n2 + j);
                }
                j = succs.getNextElement();
            }
        }
    }

    private void makeLoops(int source, int cc, boolean sink) throws ContradictionException {
        if (cc == this.sccOf[source]) {
            if (sink) {
                this.contradiction(((IntVar[])this.vars)[0], "");
            } else {
                return;
            }
        }
        if (cc == this.sccOf[this.n]) {
            if (sink) {
                return;
            }
            this.contradiction(((IntVar[])this.vars)[0], "");
        }
        int i = this.SCCfinder.getSCCFirstNode(cc);
        while (i >= 0) {
            ((IntVar[])this.vars)[i].instantiateTo(i + this.offSet, this.aCause);
            i = this.SCCfinder.getNextNode(i);
        }
        this.mates[cc].clear();
        if (sink) {
            ISet ps = this.G_R.getPredOf(cc);
            int p = ps.getFirstElement();
            while (p >= 0) {
                this.G_R.removeArc(p, cc);
                if (this.G_R.getSuccOf(p).isEmpty()) {
                    this.makeLoops(source, p, true);
                }
                p = ps.getNextElement();
            }
        } else {
            ISet ss = this.G_R.getSuccOf(cc);
            int s = ss.getFirstElement();
            while (s >= 0) {
                this.G_R.removeArc(cc, s);
                if (this.G_R.getPredOf(s).isEmpty()) {
                    this.makeLoops(source, s, false);
                }
                s = ss.getNextElement();
            }
        }
    }

    private void filterFromInst(int source) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            int to = ((IntVar[])this.vars)[i].getValue() - this.offSet;
            int x = this.sccOf[i];
            if (to == source) {
                to = this.n;
            }
            if (to == -1 || this.sccOf[to] == x || this.mates[x].getSize() <= 1) continue;
            int arc = (i + 1) * this.n2 + to;
            int a = this.mates[x].getFirstElement();
            while (a >= 0) {
                if (a != arc) {
                    int val = a % this.n2;
                    if (val == this.n) {
                        val = source;
                    }
                    ((IntVar[])this.vars)[a / this.n2 - 1].removeValue(val + this.offSet, this.aCause);
                }
                a = this.mates[x].getNextElement();
            }
            this.mates[x].clear();
            this.mates[x].add(arc);
        }
    }

    private void checkSCCLink() throws ContradictionException {
        int sccFrom = this.G_R.getNodes().getFirstElement();
        while (sccFrom >= 0) {
            int door = -1;
            int i = this.mates[sccFrom].getFirstElement();
            while (i >= 0) {
                if (door == -1) {
                    door = i / this.n2 - 1;
                } else if (door != i / this.n2 - 1) {
                    return;
                }
                i = this.mates[sccFrom].getNextElement();
            }
            if (door >= 0) {
                int lb = ((IntVar[])this.vars)[door].getLB();
                int ub = ((IntVar[])this.vars)[door].getUB();
                int v = lb;
                while (v <= ub) {
                    if (this.sccOf[v - this.offSet] == sccFrom && (v - this.offSet != door || this.mandSCC.get(sccFrom))) {
                        ((IntVar[])this.vars)[door].removeValue(v, this.aCause);
                    }
                    v = ((IntVar[])this.vars)[door].nextValue(v);
                }
            }
            sccFrom = this.G_R.getNodes().getNextElement();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropSubCircuitSCC(aVars, this.offSet));
        }
    }
}

