/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.map.hash.THashMap;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.SimpleDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropSubcircuit_AntiArboFiltering
extends Propagator<IntVar> {
    private DirectedGraph connectedGraph;
    private int n;
    private AbstractLengauerTarjanDominatorsFinder domFinder;
    private int offSet;
    private Random rd = new Random(0L);
    private int[] rootCandidates;

    public PropSubcircuit_AntiArboFiltering(IntVar[] succs, int offSet) {
        super((Variable[])succs, PropagatorPriority.QUADRATIC, false);
        this.n = succs.length;
        this.offSet = offSet;
        this.connectedGraph = new DirectedGraph(this.n + 1, SetType.LINKED_LIST, false);
        this.domFinder = new SimpleDominatorsFinder(this.n, this.connectedGraph);
        this.rootCandidates = new int[this.n];
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateLowerBound(this.offSet, this.aCause);
                ((IntVar[])this.vars)[i].updateUpperBound(this.n - 1 + this.offSet, this.aCause);
            }
        }
        int size = 0;
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
            this.rootCandidates[size++] = i;
        }
        if (size > 0) {
            this.filterFromPostDom(this.rootCandidates[this.rd.nextInt(size)]);
        }
    }

    private void filterFromPostDom(int duplicatedNode) throws ContradictionException {
        int y;
        int ub;
        int i;
        for (i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccOf(i).clear();
            this.connectedGraph.getPredOf(i).clear();
        }
        for (i = 0; i < this.n; ++i) {
            if (i == duplicatedNode || ((IntVar[])this.vars)[i].contains(i + this.offSet)) {
                this.connectedGraph.addArc(i, this.n);
                continue;
            }
            ub = ((IntVar[])this.vars)[i].getUB();
            y = ((IntVar[])this.vars)[i].getLB();
            while (y <= ub) {
                this.connectedGraph.addArc(i, y - this.offSet);
                y = ((IntVar[])this.vars)[i].nextValue(y);
            }
        }
        if (this.domFinder.findPostDominators()) {
            for (int x = 0; x < this.n; ++x) {
                if (x == duplicatedNode) continue;
                ub = ((IntVar[])this.vars)[x].getUB();
                y = ((IntVar[])this.vars)[x].getLB();
                while (y <= ub) {
                    if (x != y && this.domFinder.isDomminatedBy(y - this.offSet, x)) {
                        ((IntVar[])this.vars)[x].removeValue(y, this.aCause);
                        ((IntVar[])this.vars)[y - this.offSet].removeValue(y, this.aCause);
                    }
                    y = ((IntVar[])this.vars)[x].nextValue(y);
                }
            }
        } else {
            this.contradiction(((IntVar[])this.vars)[0], "the source cannot reach all nodes");
        }
    }

    @Override
    public ESat isEntailed() {
        if (!this.isCompletelyInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropSubcircuit_AntiArboFiltering(aVars, this.offSet));
        }
    }
}

