/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cnf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.variables.BoolVar;

public class LogicTreeToolBox {
    private static ThreadLocal<LogicComparator> comp = new ThreadLocal<LogicComparator>(){

        @Override
        protected LogicComparator initialValue() {
            return new LogicComparator();
        }
    };

    protected LogicTreeToolBox() {
    }

    public static void expandNot(LogOp n) {
        if (n.isNot()) {
            n.flip();
        }
        ILogical[] children = n.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isLit()) continue;
            LogicTreeToolBox.expandNot((LogOp)children[i]);
        }
    }

    public static void merge(LogOp.Operator op, LogOp n) {
        if (n.is(op)) {
            ILogical[] children = n.getChildren();
            for (int i = 0; i < children.length; ++i) {
                LogOp nc;
                ILogical child = children[i];
                if (child.isLit() || !(nc = (LogOp)child).is(op)) continue;
                LogicTreeToolBox.merge(op, nc);
                ILogical[] subchildren = nc.getChildren();
                n.removeChild(child);
                for (int j = 0; j < subchildren.length; ++j) {
                    n.addChild(subchildren[j]);
                }
            }
        }
    }

    public static LogOp developOr(LogOp n) {
        ILogical t1 = n.getAndChild();
        ILogical t2 = n.getChildBut(t1);
        LogOp tt = LogOp.and(new ILogical[0]);
        if (!t1.isLit()) {
            LogOp n1 = (LogOp)t1;
            ILogical[] t1cs = n1.getChildren();
            for (int i = 0; i < t1cs.length; ++i) {
                ILogical t1c = t1cs[i];
                if (t2.isLit()) {
                    tt.addChild(LogOp.or(t1c, t2));
                    continue;
                }
                ILogical[] t2cs = ((LogOp)t2).getChildren();
                for (int j = 0; j < t2cs.length; ++j) {
                    ILogical t2c = t2cs[j];
                    tt.addChild(LogOp.or(t1c, t2c));
                }
            }
        }
        n.removeChild(t1);
        n.removeChild(t2);
        if (n.getNbChildren() == 0) {
            return tt;
        }
        n.addChild(tt);
        return n;
    }

    public static LogOp distribute(LogOp n) {
        if (n.is(LogOp.Operator.AND)) {
            ILogical[] children = n.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isLit()) continue;
                children[i] = LogicTreeToolBox.distribute((LogOp)children[i]);
            }
        } else {
            if (n.hasOrChild()) {
                LogicTreeToolBox.merge(LogOp.Operator.OR, n);
            }
            if (n.hasAndChild() && n.getNbChildren() > 1) {
                n = LogicTreeToolBox.distribute(LogicTreeToolBox.developOr(n));
            }
        }
        LogicTreeToolBox.merge(LogOp.Operator.AND, n);
        return n;
    }

    private static BoolVar[] extract(ILogical node) {
        if (node.isLit()) {
            return new BoolVar[]{(BoolVar)node};
        }
        return ((LogOp)node).flattenBoolVar();
    }

    public static ILogical simplify(ILogical t, Solver solver) {
        if (t.isLit()) {
            return t;
        }
        LogOp n = (LogOp)t;
        if (n.is(LogOp.Operator.OR)) {
            ILogical[] children = n.getChildren();
            HashMap<BoolVar, ILogical> lits = new HashMap<BoolVar, ILogical>();
            for (int i = 0; i < children.length; ++i) {
                BoolVar var = LogicTreeToolBox.extract(children[i])[0];
                BoolVar boolVar = var = var.isNot() ? var.not() : var;
                if (lits.containsKey(var)) {
                    ILogical prev = (ILogical)lits.get(var);
                    if (prev.isNot() == children[i].isNot()) continue;
                    return solver.ONE;
                }
                lits.put(var, children[i]);
            }
        } else if (!n.hasOrChild()) {
            ILogical[] children = n.getChildren();
            HashMap<BoolVar, ILogical> lits = new HashMap<BoolVar, ILogical>();
            for (int i = 0; i < children.length; ++i) {
                BoolVar var = LogicTreeToolBox.extract(children[i])[0];
                BoolVar boolVar = var = var.isNot() ? var.not() : var;
                if (lits.containsKey(var)) {
                    ILogical prev = (ILogical)lits.get(var);
                    if (prev.isNot() == children[i].isNot()) continue;
                    return solver.ZERO;
                }
                lits.put(var, children[i]);
            }
        } else {
            ILogical[] children = n.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isLit()) continue;
                children[i] = LogicTreeToolBox.simplify(children[i], solver);
            }
        }
        return t;
    }

    public static ILogical simplifySingleton(ILogical l, Solver solver) {
        if (l.isLit()) {
            return l;
        }
        LogOp t = (LogOp)l;
        ILogical[] children = t.getChildren();
        ArrayList<ILogical> toRemove = new ArrayList<ILogical>();
        for (int i = 0; i < children.length; ++i) {
            if (!solver.ONE.equals(children[i])) continue;
            toRemove.add(children[i]);
        }
        toRemove.forEach(t::removeChild);
        if (t.getNbChildren() == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static ILogical toCNF(LogOp logOp, Solver solver) {
        LogicTreeToolBox.expandNot(logOp);
        logOp = LogicTreeToolBox.distribute(logOp);
        if (logOp.is(LogOp.Operator.OR)) {
            Arrays.sort(logOp.getChildren(), comp.get());
        }
        ILogical[] children = logOp.getChildren();
        for (int i = 0; i < children.length; ++i) {
            LogOp nc;
            if (children[i].isLit() || !(nc = (LogOp)children[i]).is(LogOp.Operator.OR)) continue;
            Arrays.sort(nc.getChildren(), comp.get());
        }
        ILogical l = LogicTreeToolBox.simplify(logOp, solver);
        if (!(l = LogicTreeToolBox.simplifySingleton(l, solver)).isLit()) {
            ((LogOp)l).cleanFlattenBoolVar();
        }
        return l;
    }

    private static class LogicComparator
    implements Comparator<ILogical> {
        private LogicComparator() {
        }

        @Override
        public int compare(ILogical o1, ILogical o2) {
            if (o1.isNot() == o2.isNot()) {
                return 0;
            }
            if (o2.isNot()) {
                return -1;
            }
            return 1;
        }
    }
}

