/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cnf;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Deprecated
public class PropClause
extends Propagator<BoolVar> {
    int watchLit1;
    int watchLit2;
    int nbvars;

    public PropClause(LogOp t) {
        super((Variable[])t.flattenBoolVar(), PropagatorPriority.LINEAR, true);
        this.nbvars = ((BoolVar[])this.vars).length;
    }

    public PropClause(BoolVar bv) {
        super((Variable[])new BoolVar[]{bv}, PropagatorPriority.UNARY, true);
        this.nbvars = 1;
    }

    void awakeOnInst(int index) throws ContradictionException {
        int val = ((BoolVar[])this.vars)[index].getValue();
        if (index < this.nbvars && val == 1) {
            this.setPassive();
            return;
        }
        if (this.watchLit1 == index) {
            this.setWatchLiteral(this.watchLit2);
        } else if (this.watchLit2 == index) {
            this.setWatchLiteral(this.watchLit1);
        }
    }

    private void setWatchLiteral(int otherWL) throws ContradictionException {
        int i;
        int cnt = 0;
        for (i = 0; i < this.nbvars; ++i) {
            BoolVar bv = ((BoolVar[])this.vars)[i];
            if (bv.isInstantiated()) {
                if (bv.getValue() == 1) {
                    this.setPassive();
                    return;
                }
                ++cnt;
                continue;
            }
            if (i == otherWL) continue;
            this.watchLit1 = i;
            this.watchLit2 = otherWL;
            return;
        }
        if (cnt == this.nbvars) {
            this.contradiction(null, "Inconsistent");
        }
        if (i == this.nbvars) {
            ((BoolVar[])this.vars)[otherWL].instantiateTo(1, this.aCause);
            this.setPassive();
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((BoolVar[])this.vars).length == 1) {
            ((BoolVar[])this.vars)[0].instantiateTo(1, this.aCause);
            this.setPassive();
        } else {
            int n = ((BoolVar[])this.vars).length;
            int wl = 0;
            int cnt = 0;
            for (int i = 0; i < n && wl < 2; ++i) {
                BoolVar bv = ((BoolVar[])this.vars)[i];
                if (bv.isInstantiated()) {
                    if (bv.getValue() == 1) {
                        this.setPassive();
                        return;
                    }
                    ++cnt;
                    continue;
                }
                this.watchLit2 = this.watchLit1;
                this.watchLit1 = i;
                ++wl;
            }
            if (cnt == n) {
                this.contradiction(null, "Inconsistent");
            } else if (cnt == n - 1) {
                this.setWatchLiteral(this.watchLit1);
            }
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            this.awakeOnInst(varIdx);
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder();
        for (int i = 0; i < this.nbvars; ++i) {
            st.append(((BoolVar[])this.vars)[i].getName()).append(" or ");
        }
        st.replace(st.length() - 4, st.length(), "");
        return st.toString();
    }

    @Override
    public ESat isEntailed() {
        int cnt = ((BoolVar[])this.vars).length;
        for (int i = 0; i < this.nbvars; ++i) {
            if (!((BoolVar[])this.vars)[i].isInstantiated()) continue;
            if (((BoolVar[])this.vars)[i].getValue() == 1) {
                return ESat.TRUE;
            }
            --cnt;
        }
        if (cnt == 0) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

