/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cnf;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.cnf.SatSolver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropSat
extends Propagator<BoolVar> {
    SatSolver sat_;
    TObjectIntHashMap<BoolVar> indices_;
    IStateInt sat_trail_;
    TIntList early_deductions_;

    public PropSat(Solver solver) {
        super((Variable[])new BoolVar[]{solver.ONE}, PropagatorPriority.VERY_SLOW, true);
        this.vars = new BoolVar[0];
        this.indices_ = new TObjectIntHashMap();
        this.sat_ = new SatSolver();
        this.early_deductions_ = new TIntArrayList();
        this.sat_trail_ = solver.getEnvironment().makeInt();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.sat_.initPropagator();
        this.applyEarlyDeductions();
        for (int i = 0; i < ((BoolVar[])this.vars).length; ++i) {
            BoolVar var = ((BoolVar[])this.vars)[i];
            if (!var.isInstantiated()) continue;
            this.VariableBound(i);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.VariableBound(idxVarInProp);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            for (SatSolver.Clause c : this.sat_.clauses) {
                int cnt = 0;
                for (int i = 0; i < c.size(); ++i) {
                    int lit = c._g(i);
                    boolean sign = SatSolver.sign(lit);
                    int var = SatSolver.var(lit);
                    int val = ((BoolVar[])this.vars)[var].getValue();
                    if (val != (sign ? 0 : 1)) break;
                    ++cnt;
                }
                if (cnt != c.size()) continue;
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public SatSolver getSatSolver() {
        return this.sat_;
    }

    public int Literal(BoolVar expr) {
        if (this.indices_.containsKey(expr)) {
            return SatSolver.makeLiteral(this.indices_.get(expr), true);
        }
        int var = this.sat_.newVariable();
        assert (((BoolVar[])this.vars).length == var);
        this.addVariable(new BoolVar[]{expr});
        this.indices_.put(expr, var);
        return SatSolver.makeLiteral(var, true);
    }

    void VariableBound(int index) throws ContradictionException {
        boolean new_value;
        int var;
        int lit;
        if (this.sat_trail_.get() < this.sat_.trailMarker()) {
            this.sat_.cancelUntil(this.sat_trail_.get());
            assert (this.sat_trail_.get() == this.sat_.trailMarker());
        }
        if (!this.sat_.propagateOneLiteral(lit = SatSolver.makeLiteral(var = index, new_value = ((BoolVar[])this.vars)[index].getValue() != 0))) {
            this.contradiction(null, "clause unsat");
        } else {
            this.sat_trail_.set(this.sat_.trailMarker());
            for (int i = 0; i < this.sat_.touched_variables_.size(); ++i) {
                lit = this.sat_.touched_variables_.get(i);
                var = SatSolver.var(lit);
                boolean assigned_bool = SatSolver.sign(lit);
                ((BoolVar[])this.vars)[var].instantiateTo(assigned_bool ? 1 : 0, this);
            }
        }
    }

    public boolean addClause(TIntList lits) {
        boolean result = this.sat_.addClause(lits);
        this.storeEarlyDeductions();
        return result;
    }

    public boolean addEmptyClause() {
        return this.sat_.addEmptyClause();
    }

    public boolean addClause(int p) {
        boolean result = this.sat_.addClause(p);
        this.storeEarlyDeductions();
        return result;
    }

    public boolean addClause(int p, int q) {
        boolean result = this.sat_.addClause(p, q);
        this.storeEarlyDeductions();
        return result;
    }

    public boolean addClause(int p, int q, int r) {
        boolean result = this.sat_.addClause(p, q, r);
        this.storeEarlyDeductions();
        return result;
    }

    private void storeEarlyDeductions() {
        for (int i = 0; i < this.sat_.touched_variables_.size(); ++i) {
            int lit = this.sat_.touched_variables_.get(i);
            this.early_deductions_.add(lit);
        }
        this.sat_.touched_variables_.clear();
    }

    void applyEarlyDeductions() throws ContradictionException {
        for (int i = 0; i < this.early_deductions_.size(); ++i) {
            int lit = this.early_deductions_.get(i);
            int var = SatSolver.var(lit);
            boolean assigned_bool = SatSolver.sign(lit);
            ((BoolVar[])this.vars)[var].instantiateTo(assigned_bool ? 1 : 0, this);
        }
    }

    public static void declareVariable(PropSat sat, BoolVar var) {
        sat.Literal(var);
    }
}

