/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.count;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropCountVar
extends Propagator<IntVar> {
    private int n;
    private IntVar val;
    private IntVar card;

    public PropCountVar(IntVar[] decvars, IntVar restrictedValue, IntVar valueCardinality) {
        super((Variable[])ArrayUtils.append(decvars, {valueCardinality, restrictedValue}), PropagatorPriority.QUADRATIC, false);
        this.n = decvars.length;
        this.card = ((IntVar[])this.vars)[this.n];
        this.val = ((IntVar[])this.vars)[this.n + 1];
    }

    @Override
    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("PropCountVar_(");
        for (i = 0; i < Math.min(4, ((IntVar[])this.vars).length); ++i) {
            st.append(((IntVar[])this.vars)[i].getName()).append(", ");
        }
        if (i < ((IntVar[])this.vars).length - 2) {
            st.append("...,");
        }
        st.append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1].getName()).append(")");
        return st.toString();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        int minCard = 0xCCCCCCC;
        int maxCard = -minCard;
        int cardLB = this.card.getLB();
        int cardUB = this.card.getUB();
        int value = this.val.getLB();
        while (value <= this.val.getUB()) {
            int min = 0;
            int max = 0;
            for (i = 0; i < this.n; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                if (!v.contains(value)) continue;
                ++max;
                if (!v.isInstantiated()) continue;
                ++min;
            }
            if (cardLB > max || cardUB < min) {
                this.val.removeValue(value, this.aCause);
            } else {
                minCard = Math.min(minCard, min);
                maxCard = Math.max(maxCard, max);
            }
            value = this.val.nextValue(value);
        }
        this.card.updateLowerBound(minCard, this.aCause);
        this.card.updateUpperBound(maxCard, this.aCause);
        if (this.val.isInstantiated() && this.card.isInstantiated()) {
            int nb = this.card.getValue();
            int value2 = this.val.getValue();
            if (maxCard == nb) {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    if (!((IntVar[])this.vars)[i2].contains(value2)) continue;
                    ((IntVar[])this.vars)[i2].instantiateTo(value2, this.aCause);
                }
                this.setPassive();
            } else if (minCard == nb) {
                int nbInst = 0;
                for (i = 0; i < this.n; ++i) {
                    if (!((IntVar[])this.vars)[i].contains(value2)) continue;
                    if (((IntVar[])this.vars)[i].isInstantiated()) {
                        ++nbInst;
                        continue;
                    }
                    ((IntVar[])this.vars)[i].removeValue(value2, this.aCause);
                }
                this.card.instantiateTo(nbInst, this.aCause);
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public ESat isEntailed() {
        boolean support = false;
        boolean instSupport = false;
        int value = this.val.getLB();
        while (value <= this.val.getUB()) {
            int min = 0;
            int max = 0;
            for (int i = 0; i < this.n; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                if (!v.contains(value)) continue;
                ++max;
                if (!v.isInstantiated()) continue;
                ++min;
            }
            if (this.card.getLB() <= max && this.card.getUB() >= min) {
                support = true;
                if (min == max) {
                    instSupport = true;
                }
            }
            value = this.val.nextValue(value);
        }
        if (!support) {
            return ESat.FALSE;
        }
        if (this.val.isInstantiated() && instSupport && this.card.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 2;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size - 1].duplicate(solver, identitymap);
            IntVar aVar1 = (IntVar)identitymap.get(((IntVar[])this.vars)[size - 1]);
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar aVar2 = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropCountVar(aVars, aVar2, aVar1));
        }
    }
}

