/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.count;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropCount_AC
extends Propagator<IntVar> {
    private int n;
    private int value;
    private ISet possibles;
    private ISet mandatories;

    public PropCount_AC(IntVar[] decvars, int restrictedValue, IntVar valueCardinality) {
        super((Variable[])ArrayUtils.append(decvars, {valueCardinality}), PropagatorPriority.LINEAR, true);
        this.value = restrictedValue;
        this.n = decvars.length;
        this.possibles = SetFactory.makeStoredSet(SetType.BITSET, this.n, this.solver);
        this.mandatories = SetFactory.makeStoredSet(SetType.BITSET, this.n, this.solver);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("PropFastCount_(");
        for (i = 0; i < Math.min(4, ((IntVar[])this.vars).length); ++i) {
            st.append(((IntVar[])this.vars)[i].getName()).append(", ");
        }
        if (i < ((IntVar[])this.vars).length - 2) {
            st.append("...,");
        }
        st.append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1].getName()).append(")");
        return st.toString();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.mandatories.clear();
            this.possibles.clear();
            for (int i = 0; i < this.n; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                int ub = v.getUB();
                if (v.isInstantiated()) {
                    if (ub != this.value) continue;
                    this.mandatories.add(i);
                    continue;
                }
                if (!v.contains(this.value)) continue;
                this.possibles.add(i);
            }
        }
        this.filter();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx < this.n) {
            if (this.possibles.contain(varIdx)) {
                if (!((IntVar[])this.vars)[varIdx].contains(this.value)) {
                    this.possibles.remove(varIdx);
                    this.filter();
                } else if (((IntVar[])this.vars)[varIdx].isInstantiated()) {
                    this.possibles.remove(varIdx);
                    this.mandatories.add(varIdx);
                    this.filter();
                }
            }
        } else {
            this.filter();
        }
    }

    private void filter() throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateLowerBound(this.mandatories.getSize(), this.aCause);
        ((IntVar[])this.vars)[this.n].updateUpperBound(this.mandatories.getSize() + this.possibles.getSize(), this.aCause);
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            int nb = ((IntVar[])this.vars)[this.n].getValue();
            if (this.possibles.getSize() + this.mandatories.getSize() == nb) {
                int j = this.possibles.getFirstElement();
                while (j >= 0) {
                    ((IntVar[])this.vars)[j].instantiateTo(this.value, this.aCause);
                    j = this.possibles.getNextElement();
                }
                this.setPassive();
            } else if (this.mandatories.getSize() == nb) {
                int j = this.possibles.getFirstElement();
                while (j >= 0) {
                    if (((IntVar[])this.vars)[j].removeValue(this.value, this.aCause)) {
                        this.possibles.remove(j);
                    }
                    j = this.possibles.getNextElement();
                }
                if (this.possibles.isEmpty()) {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx >= this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public ESat isEntailed() {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            if (v.isInstantiatedTo(this.value)) {
                ++min;
                ++max;
                continue;
            }
            if (!v.contains(this.value)) continue;
            ++max;
        }
        if (((IntVar[])this.vars)[this.n].getLB() > max || ((IntVar[])this.vars)[this.n].getUB() < min) {
            return ESat.FALSE;
        }
        if (!((IntVar[])this.vars)[this.n].isInstantiated() || max != min) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar aVar = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropCount_AC(aVars, this.value, aVar));
        }
    }
}

