/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.HeightCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.NRJCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.PropFullCumulative;
import org.chocosolver.solver.constraints.nary.cumulative.PropGraphCumulative;
import org.chocosolver.solver.constraints.nary.cumulative.SweepCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.SweepHeiSortCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.TimeCumulFilter;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.util.tools.ArrayUtils;

public class Cumulative
extends Constraint {
    public Cumulative(Task[] tasks, IntVar[] heights, IntVar capacity, boolean graphBased, Filter ... filters) {
        super("Cumulative", Cumulative.createPropagators(tasks, heights, capacity, graphBased, filters));
    }

    private static Propagator[] createPropagators(Task[] tasks, IntVar[] heights, IntVar capa, boolean graphBased, Filter ... filters) {
        int n = tasks.length;
        assert (n == heights.length && n > 0);
        IntVar[] vars = Cumulative.extract(tasks, heights, capa);
        IntVar[] s = Arrays.copyOfRange(vars, 0, n);
        IntVar[] d = Arrays.copyOfRange(vars, n, 2 * n);
        IntVar[] e = Arrays.copyOfRange(vars, 2 * n, 3 * n);
        IntVar[] h = Arrays.copyOfRange(vars, 3 * n, 4 * n);
        if (graphBased) {
            return new Propagator[]{new PropGraphCumulative(s, d, e, h, capa, true, filters), new PropGraphCumulative(s, d, e, h, capa, false, filters)};
        }
        return new Propagator[]{new PropFullCumulative(s, d, e, h, capa, true, filters), new PropFullCumulative(s, d, e, h, capa, false, filters)};
    }

    public static IntVar[] extract(Task[] tasks, IntVar[] heights, IntVar capa) {
        int n = tasks.length;
        IntVar[] starts = new IntVar[n];
        IntVar[] durations = new IntVar[n];
        IntVar[] ends = new IntVar[n];
        for (int i = 0; i < n; ++i) {
            starts[i] = tasks[i].getStart();
            durations[i] = tasks[i].getDuration();
            ends[i] = tasks[i].getEnd();
        }
        return ArrayUtils.append(starts, durations, ends, heights, {capa});
    }

    public static enum Filter {
        HEIGHTS{

            @Override
            public CumulFilter make(int n, Propagator<IntVar> cause) {
                return new HeightCumulFilter(n, cause);
            }
        }
        ,
        TIME{

            @Override
            public CumulFilter make(int n, Propagator<IntVar> cause) {
                return new TimeCumulFilter(n, cause);
            }
        }
        ,
        SWEEP{

            @Override
            public CumulFilter make(int n, Propagator<IntVar> cause) {
                return new SweepCumulFilter(n, cause);
            }
        }
        ,
        SWEEP_HEI_SORT{

            @Override
            public CumulFilter make(int n, Propagator<IntVar> cause) {
                return new SweepHeiSortCumulFilter(n, cause);
            }
        }
        ,
        NRJ{

            @Override
            public CumulFilter make(int n, Propagator<IntVar> cause) {
                return new NRJCumulFilter(n, cause);
            }
        };


        public abstract CumulFilter make(int var1, Propagator<IntVar> var2);
    }
}

