/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;

public class NRJCumulFilter
extends CumulFilter {
    protected int[] sor_array;
    protected ArraySort sorter;
    protected IntComparator comparator;
    protected int[] slb;
    protected int[] dlb;
    protected int[] eub;
    protected int[] hlb;

    public NRJCumulFilter(int n, Propagator cause) {
        super(n, cause);
        this.sor_array = new int[n];
        this.sorter = new ArraySort(n, false, true);
        this.slb = new int[n];
        this.dlb = new int[n];
        this.eub = new int[n];
        this.hlb = new int[n];
        this.comparator = (i1, i2) -> {
            int coef1 = 100 * this.dlb[i1] * this.hlb[i1] / (this.eub[i1] - this.slb[i1]);
            int coef2 = 100 * this.dlb[i2] * this.hlb[i2] / (this.eub[i2] - this.slb[i2]);
            return coef2 - coef1;
        };
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks) throws ContradictionException {
        int idx = 0;
        int i = tasks.getFirstElement();
        while (i >= 0) {
            if (d[i].getLB() > 0) {
                this.slb[i] = s[i].getLB();
                this.dlb[i] = d[i].getLB();
                this.eub[i] = e[i].getUB();
                this.hlb[i] = h[i].getLB();
                assert (this.eub[i] > this.slb[i]);
                this.sor_array[idx++] = i;
            }
            i = tasks.getNextElement();
        }
        this.sorter.sort(this.sor_array, idx, this.comparator);
        double xMin = 1.073741823E9;
        double xMax = -1.073741824E9;
        double surface = 0.0;
        double camax = capa.getUB();
        for (int k = 0; k < idx; ++k) {
            int i2 = this.sor_array[k];
            if (!((xMax = Math.max(xMax, (double)this.eub[i2])) >= (xMin = Math.min(xMin, (double)this.slb[i2])))) continue;
            double availSurf = (xMax - xMin) * camax - surface;
            if (this.dlb[i2] > 0) {
                h[i2].updateUpperBound((int)Math.floor(availSurf / (double)this.dlb[i2] + 0.01), this.aCause);
            }
            if (this.hlb[i2] > 0) {
                d[i2].updateUpperBound((int)Math.floor(availSurf / (double)this.hlb[i2] + 0.01), this.aCause);
            }
            surface += (double)(this.dlb[i2] * this.hlb[i2]);
            if (xMax > xMin) {
                capa.updateLowerBound((int)Math.ceil(surface / (xMax - xMin) - 0.01), this.aCause);
            }
            if (!(surface > (xMax - xMin) * camax)) continue;
            this.aCause.contradiction(capa, "");
        }
    }
}

