/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.tools.ArrayUtils;

public class PropFullCumulative
extends Propagator<IntVar> {
    protected final int n;
    protected final IntVar[] s;
    protected final IntVar[] d;
    protected final IntVar[] e;
    protected final IntVar[] h;
    protected final IntVar capa;
    protected CumulFilter[] filters;
    protected ISet allTasks;
    protected final boolean fast;
    protected final int awakeningMask;
    protected final IStateInt lastCapaMax;
    protected final Cumulative.Filter[] _filters;

    protected PropFullCumulative(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, boolean reactToFineEvt, boolean fast, Cumulative.Filter ... filters) {
        super((Variable[])ArrayUtils.append(s, d, e, h, {capa}), PropagatorPriority.QUADRATIC, reactToFineEvt);
        this.n = s.length;
        if (this.n != d.length || this.n != e.length || this.n != h.length) {
            throw new UnsupportedOperationException();
        }
        this.fast = fast;
        this.s = (IntVar[])Arrays.copyOfRange(this.vars, 0, this.n);
        this.d = (IntVar[])Arrays.copyOfRange(this.vars, this.n, this.n * 2);
        this.e = (IntVar[])Arrays.copyOfRange(this.vars, this.n * 2, this.n * 3);
        this.h = (IntVar[])Arrays.copyOfRange(this.vars, this.n * 3, this.n * 4);
        this.capa = ((IntVar[])this.vars)[4 * this.n];
        this.filters = new CumulFilter[filters.length];
        this._filters = filters;
        for (int f = 0; f < filters.length; ++f) {
            this.filters[f] = filters[f].make(this.n, this);
        }
        this.awakeningMask = fast ? IntEventType.instantiation() : IntEventType.boundAndInst();
        this.lastCapaMax = this.solver.getEnvironment().makeInt(capa.getUB() + 1);
        this.allTasks = SetFactory.makeFullSet(this.n);
    }

    public PropFullCumulative(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, boolean fast, Cumulative.Filter ... filters) {
        this(s, d, e, h, capa, false, fast, filters);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (idx >= 4 * this.n) {
            return IntEventType.DECUPP.getMask() + IntEventType.INSTANTIATE.getMask();
        }
        return this.awakeningMask;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.propIni();
        }
        this.updateMaxCapa();
        this.filter(this.allTasks);
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    protected void propIni() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.d[i].updateLowerBound(0, this.aCause);
            this.h[i].updateLowerBound(0, this.aCause);
            this.s[i].updateLowerBound(this.e[i].getLB() - this.d[i].getUB(), this.aCause);
            this.s[i].updateUpperBound(this.e[i].getUB() - this.d[i].getLB(), this.aCause);
            this.e[i].updateUpperBound(this.s[i].getUB() + this.d[i].getUB(), this.aCause);
            this.e[i].updateLowerBound(this.s[i].getLB() + this.d[i].getLB(), this.aCause);
            this.d[i].updateUpperBound(this.e[i].getUB() - this.s[i].getLB(), this.aCause);
            this.d[i].updateLowerBound(this.e[i].getLB() - this.s[i].getUB(), this.aCause);
        }
    }

    protected void updateMaxCapa() throws ContradictionException {
        if (this.lastCapaMax.get() != this.capa.getUB()) {
            int capaMax = this.capa.getUB();
            this.lastCapaMax.set(capaMax);
            for (int i = 0; i < this.n; ++i) {
                this.h[i].updateUpperBound(capaMax, this.aCause);
            }
        }
    }

    public void filter(ISet tasks) throws ContradictionException {
        for (CumulFilter cf : this.filters) {
            cf.filter(this.s, this.d, this.e, this.h, this.capa, tasks);
        }
    }

    @Override
    public ESat isEntailed() {
        int min = this.s[0].getUB();
        int max = this.e[0].getLB();
        for (int i = 0; i < this.n; ++i) {
            min = Math.min(min, this.s[i].getUB());
            max = Math.max(max, this.e[i].getLB());
            if (this.s[i].getLB() + this.d[i].getLB() <= this.e[i].getUB() && this.s[i].getUB() + this.d[i].getUB() >= this.e[i].getLB()) continue;
            return ESat.FALSE;
        }
        int maxLoad = 0;
        if (min <= max) {
            int capamax = this.capa.getUB();
            int[] consoMin = new int[max - min];
            for (int i = 0; i < this.n; ++i) {
                for (int t = this.s[i].getUB(); t < this.e[i].getLB(); ++t) {
                    int n = t - min;
                    consoMin[n] = consoMin[n] + this.h[i].getLB();
                    if (consoMin[t - min] > capamax) {
                        return ESat.FALSE;
                    }
                    maxLoad = Math.max(maxLoad, consoMin[t - min]);
                }
            }
        }
        for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        assert (min <= max);
        if (maxLoad <= ((IntVar[])this.vars)[4 * this.n].getLB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "(");
        for (int i = 0; i < this.n; ++i) {
            sb.append("[").append(((IntVar[])this.vars)[i].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 2 * this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 3 * this.n].toString()).append("],");
        }
        sb.append(((IntVar[])this.vars)[4 * this.n].toString()).append(")");
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntVar[] sVars = new IntVar[this.n];
            IntVar[] dVars = new IntVar[this.n];
            IntVar[] eVars = new IntVar[this.n];
            IntVar[] hVars = new IntVar[this.n];
            for (int i = 0; i < this.n; ++i) {
                this.s[i].duplicate(solver, identitymap);
                sVars[i] = (IntVar)identitymap.get(this.s[i]);
                this.d[i].duplicate(solver, identitymap);
                dVars[i] = (IntVar)identitymap.get(this.d[i]);
                this.e[i].duplicate(solver, identitymap);
                eVars[i] = (IntVar)identitymap.get(this.e[i]);
                this.h[i].duplicate(solver, identitymap);
                hVars[i] = (IntVar)identitymap.get(this.h[i]);
            }
            this.capa.duplicate(solver, identitymap);
            IntVar cVar = (IntVar)identitymap.get(this.capa);
            identitymap.put(this, new PropFullCumulative(sVars, dVars, eVars, hVars, cVar, this.fast, (Cumulative.Filter[])this._filters.clone()));
        }
    }
}

