/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.constraints.nary.cumulative.PropFullCumulative;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.sort.ArraySort;

public class PropGraphCumulative
extends PropFullCumulative {
    protected final UndirectedGraph g;
    protected ISet tasks;
    protected ISet toCompute;
    protected long timestamp;
    protected final Random rd = new Random(0L);
    protected int maxrd = 10;
    private static final int START = 1;
    private static final int END = 2;

    public PropGraphCumulative(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, boolean fast, Cumulative.Filter ... filters) {
        super(s, d, e, h, capa, true, fast, filters);
        this.g = new UndirectedGraph(this.n, SetType.BITSET, true);
        this.tasks = SetFactory.makeSwap(this.n, false);
        this.toCompute = SetFactory.makeSwap(this.n, false);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            super.propagate(evtmask);
            for (int i = 0; i < this.n; ++i) {
                this.g.getNeighOf(i).clear();
            }
            this.sweepBasedGraphComputation();
        } else {
            int count = 0;
            int i = this.toCompute.getFirstElement();
            while (i >= 0) {
                count += this.g.getNeighOf(i).getSize();
                i = this.toCompute.getNextElement();
            }
            if (count >= 2 * this.n) {
                this.filter(this.allTasks);
            } else {
                i = this.toCompute.getFirstElement();
                while (i >= 0) {
                    this.filterAround(i);
                    i = this.toCompute.getNextElement();
                }
            }
        }
        this.toCompute.clear();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (this.timestamp != (long)this.solver.getEnvironment().getWorldIndex()) {
            this.timestamp = this.solver.getEnvironment().getWorldIndex();
            this.toCompute.clear();
        }
        if (varIdx < 4 * this.n) {
            int v = varIdx % this.n;
            if (!(this.fast && !this.mandPartExists(v) && this.rd.nextInt(this.maxrd) != 0 || this.toCompute.contain(v))) {
                this.toCompute.add(v);
            }
        } else {
            this.updateMaxCapa();
            this.toCompute.clear();
            for (int i = 0; i < this.n; ++i) {
                this.toCompute.add(i);
            }
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    protected void filterAround(int taskIndex) throws ContradictionException {
        this.tasks.clear();
        this.tasks.add(taskIndex);
        ISet env = this.g.getNeighOf(taskIndex);
        int i = env.getFirstElement();
        while (i >= 0) {
            if (!this.disjoint(taskIndex, i)) {
                this.tasks.add(i);
            }
            i = env.getNextElement();
        }
        this.filter(this.tasks);
    }

    protected boolean mandPartExists(int i) {
        return this.s[i].getUB() < this.e[i].getLB();
    }

    protected boolean disjoint(int i, int j) {
        return this.s[i].getLB() >= this.e[j].getUB() || this.s[j].getLB() >= this.e[i].getUB();
    }

    private void naiveGraphComputation() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                if (this.disjoint(i, j)) continue;
                this.g.addEdge(i, j);
            }
        }
    }

    private void sweepBasedGraphComputation() {
        Event[] events = new Event[2 * this.n];
        ArraySort<Event> sort = new ArraySort<Event>(events.length, true, false);
        Comparator eventComparator = (e1, e2) -> {
            if (e1.date == e2.date) {
                return e1.type - e2.type;
            }
            return e1.date - e2.date;
        };
        BitSet tprune = new BitSet(this.n);
        for (int i = 0; i < this.n; ++i) {
            events[i] = new Event();
            events[i].set(1, i, this.s[i].getLB());
            events[i + this.n] = new Event();
            events[i + this.n].set(2, i, this.e[i].getUB());
        }
        sort.sort(events, 2 * this.n, eventComparator);
        int timeIndex = 0;
        block5: while (timeIndex < this.n * 2) {
            Event event = events[timeIndex++];
            switch (event.type) {
                case 1: {
                    int i = tprune.nextSetBit(0);
                    while (i >= 0) {
                        this.g.addEdge(i, event.index);
                        i = tprune.nextSetBit(i + 1);
                    }
                    tprune.set(event.index);
                    continue block5;
                }
                case 2: {
                    tprune.clear(event.index);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntVar[] sVars = new IntVar[this.n];
            IntVar[] dVars = new IntVar[this.n];
            IntVar[] eVars = new IntVar[this.n];
            IntVar[] hVars = new IntVar[this.n];
            for (int i = 0; i < this.n; ++i) {
                this.s[i].duplicate(solver, identitymap);
                sVars[i] = (IntVar)identitymap.get(this.s[i]);
                this.d[i].duplicate(solver, identitymap);
                dVars[i] = (IntVar)identitymap.get(this.d[i]);
                this.e[i].duplicate(solver, identitymap);
                eVars[i] = (IntVar)identitymap.get(this.e[i]);
                this.h[i].duplicate(solver, identitymap);
                hVars[i] = (IntVar)identitymap.get(this.h[i]);
            }
            this.capa.duplicate(solver, identitymap);
            IntVar cVar = (IntVar)identitymap.get(this.capa);
            identitymap.put(this, new PropGraphCumulative(sVars, dVars, eVars, hVars, cVar, this.fast, (Cumulative.Filter[])this._filters.clone()));
        }
    }

    private static class Event {
        protected int type;
        protected int index;
        protected int date;

        private Event() {
        }

        protected void set(int t, int i, int d) {
            this.date = d;
            this.type = t;
            this.index = i;
        }
    }
}

