/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.SweepCumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;

public class SweepHeiSortCumulFilter
extends SweepCumulFilter {
    protected final int[] sortedTasks;
    protected final ArraySort taskSorter;
    protected final IntComparator comparator;

    public SweepHeiSortCumulFilter(int n, Propagator cause) {
        super(n, cause);
        this.sortedTasks = new int[n];
        this.taskSorter = new ArraySort(n, false, true);
        this.comparator = (i1, i2) -> this.hlb[this.map[i2]] - this.hlb[this.map[i1]];
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks) throws ContradictionException {
        int size = 0;
        int t = tasks.getFirstElement();
        while (t >= 0) {
            if (d[t].getLB() > 0) {
                this.map[size] = t;
                this.sortedTasks[size] = size;
                this.hlb[t] = h[t].getLB();
                ++size;
            }
            t = tasks.getNextElement();
        }
        this.taskSorter.sort(this.sortedTasks, size, this.comparator);
        assert (this.checkSort(h, size));
        super.filter(s, d, e, h, capa, tasks);
    }

    @Override
    protected boolean sweep(IntVar capamax, IntVar[] h, int nbT) throws ContradictionException {
        this.generateMinEvents(nbT);
        if (this.nbEvents == 0) {
            return false;
        }
        this.sort.sort(this.events, this.nbEvents, this.eventComparator);
        int timeIndex = 0;
        int currentDate = this.events[timeIndex].date;
        int capa = capamax.getUB();
        int currentConso = 0;
        boolean active = false;
        while (timeIndex < this.nbEvents) {
            int nextDate = this.events[timeIndex].date;
            assert (nextDate >= currentDate);
            if (currentDate < nextDate) {
                int index;
                assert (currentConso <= capa);
                for (int i = 0; i < nbT && currentConso + this.hlb[index = this.sortedTasks[i]] > capa; ++i) {
                    if (currentDate >= this.sub[index] && this.sub[index] < this.elb[index] || this.slb[index] >= nextDate || currentDate >= this.slb[index] + this.dlb[index]) continue;
                    this.slb[index] = nextDate;
                    if (nextDate > this.sub[index]) {
                        this.aCause.contradiction(capamax, "");
                    }
                    active = true;
                }
            }
            SweepCumulFilter.Event event = this.events[timeIndex++];
            currentDate = event.date;
            if (event.type == 2) {
                assert (this.events[timeIndex].date > event.date || this.events[timeIndex].type == 2);
                capamax.updateLowerBound(currentConso += this.hlb[event.index], this.aCause);
                continue;
            }
            assert (event.type == 3);
            currentConso -= this.hlb[event.index];
        }
        return active;
    }

    @Override
    protected void generateMinEvents(int nbT) {
        this.nbEvents = 0;
        for (int i = 0; i < nbT; ++i) {
            if (this.sub[i] >= this.elb[i]) continue;
            this.events[this.nbEvents++].set(2, i, this.sub[i]);
            this.events[this.nbEvents++].set(3, i, this.elb[i]);
        }
    }

    protected boolean checkSort(IntVar[] h, int nbT) {
        for (int i2 = 0; i2 < nbT; ++i2) {
            int idx1 = this.sortedTasks[i2];
            for (int i3 = i2 + 1; i3 < nbT; ++i3) {
                int idx2 = this.sortedTasks[i3];
                assert (h[this.map[idx1]].getLB() >= h[this.map[idx2]].getLB());
            }
        }
        return true;
    }
}

