/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class TimeCumulFilter
extends CumulFilter {
    protected int[] time = new int[31];

    public TimeCumulFilter(int nbMaxTasks, Propagator cause) {
        super(nbMaxTasks, cause);
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks) throws ContradictionException {
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        int i = tasks.getFirstElement();
        while (i >= 0) {
            if (s[i].getUB() < e[i].getLB()) {
                min = Math.min(min, s[i].getUB());
                max = Math.max(max, e[i].getLB());
            }
            i = tasks.getNextElement();
        }
        if (min < max) {
            int hlb;
            int elb;
            if (max - min > this.time.length) {
                this.time = new int[max - min];
            } else {
                Arrays.fill(this.time, 0, max - min, 0);
            }
            int capaMax = capa.getUB();
            int maxC = 0;
            int i2 = tasks.getFirstElement();
            while (i2 >= 0) {
                elb = e[i2].getLB();
                hlb = h[i2].getLB();
                for (int t = s[i2].getUB(); t < elb; ++t) {
                    int n = t - min;
                    this.time[n] = this.time[n] + hlb;
                    maxC = Math.max(maxC, this.time[t - min]);
                }
                i2 = tasks.getNextElement();
            }
            capa.updateLowerBound(maxC, this.aCause);
            int i3 = tasks.getFirstElement();
            while (i3 >= 0) {
                if (!h[i3].isInstantiated()) {
                    int minH = h[i3].getUB();
                    elb = e[i3].getLB();
                    hlb = h[i3].getLB();
                    for (int t = s[i3].getUB(); t < elb; ++t) {
                        minH = Math.min(minH, capaMax - (this.time[t - min] - hlb));
                    }
                    h[i3].updateUpperBound(minH, this.aCause);
                }
                i3 = tasks.getNextElement();
            }
            i3 = tasks.getFirstElement();
            while (i3 >= 0) {
                if (d[i3].getLB() > 0 && h[i3].getLB() > 0) {
                    if (s[i3].getLB() + d[i3].getLB() > min) {
                        this.filterInf(s[i3], d[i3].getLB(), h[i3].getLB(), min, max, this.time, capaMax);
                    }
                    if (e[i3].getUB() - d[i3].getLB() < max) {
                        this.filterSup(e[i3], d[i3].getLB(), h[i3].getLB(), min, max, this.time, capaMax);
                    }
                }
                i3 = tasks.getNextElement();
            }
        }
    }

    protected void filterInf(IntVar start, int dlb, int hlb, int min, int max, int[] time, int capaMax) throws ContradictionException {
        int nbOk = 0;
        int sub = start.getUB();
        for (int t = start.getLB(); t < sub; ++t) {
            if (t < min || t >= max || hlb + time[t - min] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            start.updateLowerBound(t + 1, this.aCause);
        }
    }

    protected void filterSup(IntVar end, int dlb, int hlb, int min, int max, int[] time, int capaMax) throws ContradictionException {
        int nbOk = 0;
        int elb = end.getLB();
        for (int t = end.getUB(); t > elb; --t) {
            if (t - 1 < min || t - 1 >= max || hlb + time[t - min - 1] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            end.updateUpperBound(t - 1, this.aCause);
        }
    }
}

