/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.element;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElementV_fast
extends Propagator<IntVar> {
    private IntVar var;
    private IntVar index;
    private int offset;
    private final boolean fast;

    public PropElementV_fast(IntVar value, IntVar[] values, IntVar index, int offset, boolean fast) {
        super((Variable[])ArrayUtils.append({value, index}, values), PropagatorPriority.LINEAR, false);
        this.var = ((IntVar[])this.vars)[0];
        this.index = ((IntVar[])this.vars)[1];
        this.offset = offset;
        this.fast = fast;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        IntVar v;
        this.index.updateLowerBound(this.offset, this.aCause);
        this.index.updateUpperBound(((IntVar[])this.vars).length + this.offset - 3, this.aCause);
        int lb = this.index.getLB();
        int ub = this.index.getUB();
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        int i = lb;
        while (i <= ub) {
            if (this.disjoint(this.var, ((IntVar[])this.vars)[2 + i - this.offset])) {
                this.index.removeValue(i, this.aCause);
            }
            min = Math.min(min, ((IntVar[])this.vars)[2 + i - this.offset].getLB());
            max = Math.max(max, ((IntVar[])this.vars)[2 + i - this.offset].getUB());
            i = this.index.nextValue(i);
        }
        if (!this.index.hasEnumeratedDomain() && this.index.getUB() < ub) {
            i = ub - 1;
            while (i >= lb && this.disjoint(this.var, ((IntVar[])this.vars)[2 + i - this.offset])) {
                this.index.removeValue(i, this.aCause);
                i = this.index.previousValue(i);
            }
        }
        this.var.updateLowerBound(min, this.aCause);
        this.var.updateUpperBound(max, this.aCause);
        if (this.index.isInstantiated()) {
            this.equals(this.var, ((IntVar[])this.vars)[2 + this.index.getValue() - this.offset]);
        }
        if (this.var.isInstantiated() && this.index.isInstantiated() && (v = ((IntVar[])this.vars)[2 + this.index.getValue() - this.offset]).isInstantiated() && v.getValue() == this.var.getValue()) {
            this.setPassive();
        }
    }

    private void equals(IntVar a, IntVar b) throws ContradictionException {
        int s = a.getDomainSize() + b.getDomainSize();
        a.updateLowerBound(b.getLB(), this.aCause);
        a.updateUpperBound(b.getUB(), this.aCause);
        b.updateLowerBound(a.getLB(), this.aCause);
        b.updateUpperBound(a.getUB(), this.aCause);
        if (!this.fast) {
            int i;
            int ub;
            int lb;
            if (a.getDomainSize() != b.getDomainSize()) {
                lb = a.getLB();
                ub = a.getUB();
                i = lb;
                while (i <= ub) {
                    if (!b.contains(i)) {
                        a.removeValue(i, this.aCause);
                    }
                    i = a.nextValue(i);
                }
            }
            if (a.getDomainSize() != b.getDomainSize()) {
                lb = b.getLB();
                ub = b.getUB();
                i = lb;
                while (i <= ub) {
                    if (!a.contains(i)) {
                        b.removeValue(i, this.aCause);
                    }
                    i = b.nextValue(i);
                }
            }
        }
        if (a.getDomainSize() + b.getDomainSize() != s) {
            this.equals(a, b);
        }
    }

    private boolean disjoint(IntVar a, IntVar b) {
        if (a.getLB() > b.getUB() || b.getLB() > a.getUB()) {
            return true;
        }
        if (this.fast) {
            return false;
        }
        int lb = a.getLB();
        int ub = a.getUB();
        int i = lb;
        while (i <= ub) {
            if (b.contains(i)) {
                return false;
            }
            i = a.nextValue(i);
        }
        return true;
    }

    @Override
    public ESat isEntailed() {
        int lb = this.index.getLB();
        int ub = this.index.getUB();
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        int val = this.var.getLB();
        boolean exists = false;
        int i = lb;
        while (i <= ub) {
            int j = 2 + i - this.offset;
            if (j >= 2 && j < ((IntVar[])this.vars).length) {
                min = Math.min(min, ((IntVar[])this.vars)[j].getLB());
                max = Math.max(max, ((IntVar[])this.vars)[j].getUB());
                exists |= ((IntVar[])this.vars)[j].contains(val);
            }
            i = this.index.nextValue(i);
        }
        if (min > this.var.getUB() || max < this.var.getLB()) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && !exists) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 2;
            IntVar[] X = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i + 2].duplicate(solver, identitymap);
                X[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + 2]);
            }
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar V = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar I = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropElementV_fast(V, X, I, this.offset, this.fast));
        }
    }
}

