/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.globalcardinality;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.globalcardinality.PropFastGCC;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class GlobalCardinality
extends Constraint {
    public GlobalCardinality(IntVar[] vars, int[] values, IntVar[] cards) {
        super("GCC", GlobalCardinality.createProp(vars, values, cards));
    }

    private static Propagator createProp(IntVar[] vars, int[] values, IntVar[] cards) {
        assert (values.length == cards.length);
        TIntIntHashMap map = new TIntIntHashMap();
        int idx = 0;
        for (int v : values) {
            if (!map.containsKey(v)) {
                map.put(v, idx);
                ++idx;
                continue;
            }
            throw new UnsupportedOperationException("ERROR: multiple occurrences of value: " + v);
        }
        return new PropFastGCC(vars, values, map, cards);
    }

    public static Constraint[] reformulate(IntVar[] vars, IntVar[] card, Solver solver) {
        ArrayList<Constraint> cstrs = new ArrayList<Constraint>();
        for (int i = 0; i < card.length; ++i) {
            IntVar cste = VF.fixed(i, solver);
            BoolVar[] bs = VF.boolArray("b_" + i, vars.length, solver);
            for (int j = 0; j < vars.length; ++j) {
                LCF.ifThenElse(bs[j], ICF.arithm(vars[j], "=", cste), ICF.arithm(vars[j], "!=", cste));
            }
            cstrs.add(ICF.sum(bs, card[i]));
        }
        return cstrs.toArray(new Constraint[cstrs.size()]);
    }
}

