/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.globalcardinality;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropFastGCC
extends Propagator<IntVar> {
    private int n;
    private int n2;
    private int[] values;
    private ISet[] possibles;
    private ISet[] mandatories;
    private ISet valueToCompute;
    private TIntIntHashMap map;
    private TIntArrayList boundVar;

    public PropFastGCC(IntVar[] decvars, int[] restrictedValues, TIntIntHashMap map, IntVar[] valueCardinalities) {
        super((Variable[])ArrayUtils.append(decvars, valueCardinalities), PropagatorPriority.LINEAR, true);
        if (restrictedValues.length != valueCardinalities.length) {
            throw new UnsupportedOperationException();
        }
        this.values = restrictedValues;
        this.n = decvars.length;
        this.n2 = this.values.length;
        this.possibles = new ISet[this.n2];
        this.mandatories = new ISet[this.n2];
        this.map = map;
        for (int idx = 0; idx < this.n2; ++idx) {
            this.mandatories[idx] = SetFactory.makeStoredSet(SetType.BITSET, this.n, this.solver);
            this.possibles[idx] = SetFactory.makeStoredSet(SetType.BITSET, this.n, this.solver);
        }
        this.valueToCompute = SetFactory.makeStoredSet(SetType.BITSET, this.n2, this.solver);
        this.boundVar = new TIntArrayList();
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].hasEnumeratedDomain()) continue;
            this.boundVar.add(i);
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("PropFastGCC_(");
        for (i = 0; i < Math.min(4, ((IntVar[])this.vars).length); ++i) {
            st.append(((IntVar[])this.vars)[i].getName()).append(", ");
        }
        if (i < ((IntVar[])this.vars).length - 2) {
            st.append("...,");
        }
        st.append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1].getName()).append(")");
        return st.toString();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            int i;
            if (PropagatorEventType.isFullPropagation(evtmask)) {
                this.valueToCompute.clear();
                for (i = 0; i < this.n2; ++i) {
                    this.mandatories[i].clear();
                    this.possibles[i].clear();
                    this.valueToCompute.add(i);
                }
                for (i = 0; i < this.n; ++i) {
                    IntVar v = ((IntVar[])this.vars)[i];
                    int ub = v.getUB();
                    if (v.isInstantiated()) {
                        if (!this.map.containsKey(v.getValue())) continue;
                        int j = this.map.get(v.getValue());
                        this.mandatories[j].add(i);
                        continue;
                    }
                    int k = v.getLB();
                    while (k <= ub) {
                        if (this.map.containsKey(k)) {
                            int j = this.map.get(k);
                            this.possibles[j].add(i);
                        }
                        k = v.nextValue(k);
                    }
                }
            } else {
                i = this.valueToCompute.getFirstElement();
                while (i >= 0) {
                    int var = this.possibles[i].getFirstElement();
                    while (var >= 0) {
                        if (!((IntVar[])this.vars)[var].contains(this.values[i])) {
                            this.possibles[i].remove(var);
                        } else if (((IntVar[])this.vars)[var].isInstantiated()) {
                            this.possibles[i].remove(var);
                            this.mandatories[i].add(var);
                        }
                        var = this.possibles[i].getNextElement();
                    }
                    i = this.valueToCompute.getNextElement();
                }
            }
            evtmask = PropagatorEventType.CUSTOM_PROPAGATION.getStrengthenedMask();
        } while (this.filter());
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    private boolean filter() throws ContradictionException {
        boolean again = false;
        int i = this.valueToCompute.getFirstElement();
        while (i >= 0) {
            again |= ((IntVar[])this.vars)[this.n + i].updateLowerBound(this.mandatories[i].getSize(), this.aCause);
            again |= ((IntVar[])this.vars)[this.n + i].updateUpperBound(this.mandatories[i].getSize() + this.possibles[i].getSize(), this.aCause);
            if (((IntVar[])this.vars)[this.n + i].isInstantiated()) {
                if (this.possibles[i].getSize() + this.mandatories[i].getSize() == ((IntVar[])this.vars)[this.n + i].getLB()) {
                    int j = this.possibles[i].getFirstElement();
                    while (j >= 0) {
                        this.mandatories[i].add(j);
                        again |= ((IntVar[])this.vars)[j].instantiateTo(this.values[i], this.aCause);
                        j = this.possibles[i].getNextElement();
                    }
                    this.possibles[i].clear();
                    this.valueToCompute.remove(i);
                } else if (this.mandatories[i].getSize() == ((IntVar[])this.vars)[this.n + i].getUB()) {
                    int var = this.possibles[i].getFirstElement();
                    while (var >= 0) {
                        again |= ((IntVar[])this.vars)[var].removeValue(this.values[i], this.aCause);
                        var = this.possibles[i].getNextElement();
                    }
                    this.possibles[i].clear();
                    this.valueToCompute.remove(i);
                }
            }
            i = this.valueToCompute.getNextElement();
        }
        if (this.boundVar.size() > 0) {
            again |= this.filterBounds();
        }
        return again;
    }

    private boolean filterBounds() throws ContradictionException {
        boolean useful = false;
        for (int i = 0; i < this.boundVar.size(); ++i) {
            int index;
            int var = this.boundVar.get(i);
            if (!((IntVar[])this.vars)[var].isInstantiated()) {
                boolean b;
                int lb = ((IntVar[])this.vars)[var].getLB();
                index = -1;
                if (this.map.containsKey(lb)) {
                    index = this.map.get(lb);
                }
                boolean bl = b = index != -1 && !this.possibles[index].contain(var) && !this.mandatories[index].contain(var);
                while (b) {
                    useful = true;
                    ((IntVar[])this.vars)[var].removeValue(lb, this.aCause);
                    lb = ((IntVar[])this.vars)[var].getLB();
                    index = -1;
                    if (this.map.containsKey(lb)) {
                        index = this.map.get(lb);
                    }
                    b = index != -1 && !this.possibles[index].contain(var) && !this.mandatories[index].contain(var);
                }
                int ub = ((IntVar[])this.vars)[var].getUB();
                index = -1;
                if (this.map.containsKey(ub)) {
                    index = this.map.get(ub);
                }
                boolean bl2 = b = index != -1 && !this.possibles[index].contain(var) && !this.mandatories[index].contain(var);
                while (b) {
                    useful = true;
                    ((IntVar[])this.vars)[var].removeValue(ub, this.aCause);
                    ub = ((IntVar[])this.vars)[var].getUB();
                    index = -1;
                    if (this.map.containsKey(ub)) {
                        index = this.map.get(ub);
                    }
                    b = index != -1 && !this.possibles[index].contain(var) && !this.mandatories[index].contain(var);
                }
                continue;
            }
            int val = ((IntVar[])this.vars)[var].getValue();
            if (!this.map.containsKey(val) || this.possibles[index = this.map.get(val)].contain(var) || this.mandatories[index].contain(var)) continue;
            this.contradiction(((IntVar[])this.vars)[var], "");
        }
        return useful;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx >= this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public ESat isEntailed() {
        int i;
        int[] min = new int[this.n2];
        int[] max = new int[this.n2];
        for (i = 0; i < this.n; ++i) {
            int j;
            IntVar v = ((IntVar[])this.vars)[i];
            int ub = v.getUB();
            if (v.isInstantiated()) {
                if (!this.map.containsKey(v.getValue())) continue;
                int n = j = this.map.get(v.getValue());
                min[n] = min[n] + 1;
                int n2 = j;
                max[n2] = max[n2] + 1;
                continue;
            }
            int k = v.getLB();
            while (k <= ub) {
                if (this.map.containsKey(k)) {
                    int n = j = this.map.get(k);
                    max[n] = max[n] + 1;
                }
                k = v.nextValue(k);
            }
        }
        for (i = 0; i < this.n2; ++i) {
            if (((IntVar[])this.vars)[this.n + i].getLB() <= max[i] && ((IntVar[])this.vars)[this.n + i].getUB() >= min[i]) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.n2; ++i) {
            if (((IntVar[])this.vars)[this.n + i].isInstantiated() && max[i] == min[i]) continue;
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.n;
            IntVar[] X = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                X[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            size = this.n2;
            IntVar[] Y = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i + this.n].duplicate(solver, identitymap);
                Y[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + this.n]);
            }
            identitymap.put(this, new PropFastGCC(X, (int[])this.values.clone(), new TIntIntHashMap(this.map), Y));
        }
    }
}

