/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.lex;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropLex
extends Propagator<IntVar> {
    public final int n;
    public final IStateInt alpha;
    public final IStateInt beta;
    public boolean entailed;
    public final IntVar[] x;
    public final IntVar[] y;
    public final boolean strict;

    public PropLex(IntVar[] X, IntVar[] Y, boolean strict) {
        super((Variable[])ArrayUtils.append(X, Y), PropagatorPriority.LINEAR, true);
        this.x = (IntVar[])Arrays.copyOfRange(this.vars, 0, X.length);
        this.y = (IntVar[])Arrays.copyOfRange(this.vars, X.length, ((IntVar[])this.vars).length);
        this.strict = strict;
        this.n = X.length;
        IEnvironment environment = this.solver.getEnvironment();
        this.alpha = environment.makeInt(0);
        this.beta = environment.makeInt(0);
        this.entailed = false;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.initialize();
        } else {
            this.gacLexLeq(this.alpha.get());
        }
    }

    @Override
    public void propagate(int vIdx, int mask) throws ContradictionException {
        this.entailed = false;
        if (vIdx < this.n) {
            this.gacLexLeq(vIdx);
        } else {
            this.gacLexLeq(vIdx - this.n);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            for (int i = 0; i < this.x.length; ++i) {
                int yi;
                int xi = ((IntVar[])this.vars)[i].getValue();
                if (xi < (yi = ((IntVar[])this.vars)[i + this.n].getValue())) {
                    return ESat.TRUE;
                }
                if (xi <= yi) continue;
                return ESat.FALSE;
            }
            if (this.strict) {
                return ESat.FALSE;
            }
            return ESat.eval(((IntVar[])this.vars)[this.n - 1].getValue() == ((IntVar[])this.vars)[this.n - 1 + this.n].getValue());
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.x.length;
            IntVar[] X = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                this.x[i].duplicate(solver, identitymap);
                X[i] = (IntVar)identitymap.get(this.x[i]);
            }
            size = this.y.length;
            IntVar[] Y = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                this.y[i].duplicate(solver, identitymap);
                Y[i] = (IntVar)identitymap.get(this.y[i]);
            }
            identitymap.put(this, new PropLex(X, Y, this.strict));
        }
    }

    public boolean groundEq(IntVar x1, IntVar y1) {
        return x1.isInstantiated() && y1.isInstantiated() && x1.getValue() == y1.getValue();
    }

    public boolean leq(IntVar x1, IntVar y1) {
        return x1.getUB() <= y1.getLB();
    }

    public boolean less(IntVar x1, IntVar y1) {
        return x1.getUB() < y1.getLB();
    }

    public boolean greater(IntVar x1, IntVar y1) {
        return x1.getLB() > y1.getUB();
    }

    public boolean checkLex(int i) {
        if (!this.strict) {
            if (i == this.n - 1) {
                return this.leq(this.x[i], this.y[i]);
            }
            return this.less(this.x[i], this.y[i]);
        }
        return this.less(this.x[i], this.y[i]);
    }

    public void ACleq(int i) throws ContradictionException {
        this.x[i].updateUpperBound(this.y[i].getUB(), this.aCause);
        this.y[i].updateLowerBound(this.x[i].getLB(), this.aCause);
    }

    public void ACless(int i) throws ContradictionException {
        this.x[i].updateUpperBound(this.y[i].getUB() - 1, this.aCause);
        this.y[i].updateLowerBound(this.x[i].getLB() + 1, this.aCause);
    }

    public void updateAlpha(int i) throws ContradictionException {
        if (i == this.beta.get()) {
            this.contradiction(null, "");
        }
        if (i == this.n) {
            if (this.strict) {
                this.contradiction(null, "");
            } else {
                this.entailed = true;
                this.setPassive();
                return;
            }
        }
        if (!this.groundEq(this.x[i], this.y[i])) {
            this.alpha.set(i);
            this.gacLexLeq(i);
        } else {
            this.updateAlpha(i + 1);
        }
    }

    public void updateBeta(int i) throws ContradictionException {
        if (i + 1 == this.alpha.get()) {
            this.contradiction(null, "");
        }
        if (this.x[i].getLB() < this.y[i].getUB()) {
            this.beta.set(i + 1);
            if (this.x[i].getUB() >= this.y[i].getLB()) {
                this.gacLexLeq(i);
            }
        } else if (this.x[i].getLB() == this.y[i].getUB()) {
            this.updateBeta(i - 1);
        }
    }

    protected void initialize() throws ContradictionException {
        int i;
        this.entailed = false;
        for (i = 0; i < this.n && this.groundEq(this.x[i], this.y[i]); ++i) {
        }
        if (i == this.n) {
            if (!this.strict) {
                this.entailed = true;
                this.setPassive();
            } else {
                this.contradiction(null, "");
            }
        } else {
            int a = i;
            if (this.checkLex(i)) {
                this.setPassive();
                return;
            }
            int b = -1;
            while (i != this.n && this.x[i].getLB() <= this.y[i].getUB()) {
                if (this.x[i].getLB() == this.y[i].getUB()) {
                    if (b == -1) {
                        b = i;
                    }
                } else {
                    b = -1;
                }
                ++i;
            }
            if (!this.strict && i == this.n) {
                b = Integer.MAX_VALUE;
            }
            if (b == -1) {
                b = i;
            }
            if (a >= b) {
                this.contradiction(null, "");
            }
            this.alpha.set(a);
            this.beta.set(b);
            this.gacLexLeq(a);
        }
    }

    public void gacLexLeq(int i) throws ContradictionException {
        int a = this.alpha.get();
        int b = this.beta.get();
        if (i >= b || this.entailed) {
            return;
        }
        if (i == a && i + 1 == b) {
            this.ACless(i);
            if (this.checkLex(i)) {
                this.entailed = true;
                this.setPassive();
                return;
            }
        }
        if (i == a && i + 1 < b) {
            this.ACleq(i);
            if (this.checkLex(i)) {
                this.entailed = true;
                this.setPassive();
                return;
            }
            if (this.groundEq(this.x[i], this.y[i])) {
                this.updateAlpha(i + 1);
            }
        }
        if (a < i && i < b && (i == b - 1 && this.x[i].getLB() == this.y[i].getUB() || this.greater(this.x[i], this.y[i]))) {
            this.updateBeta(i - 1);
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(32);
        sb.append("LEX <");
        for (i = 0; i < Math.min(this.x.length - 1, 2); ++i) {
            sb.append(this.x[i]).append(", ");
        }
        if (i == 2 && this.x.length - 1 > 2) {
            sb.append("..., ");
        }
        sb.append(this.x[this.x.length - 1]);
        sb.append(">, <");
        for (i = 0; i < Math.min(this.y.length - 1, 2); ++i) {
            sb.append(this.y[i]).append(", ");
        }
        if (i == 2 && this.y.length - 1 > 2) {
            sb.append("..., ");
        }
        sb.append(this.y[this.y.length - 1]);
        sb.append(">");
        return sb.toString();
    }
}

