/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolMin
extends Propagator<BoolVar> {
    final int n;
    final IStateInt x1;
    final IStateInt x2;

    public PropBoolMin(BoolVar[] variables, BoolVar maxVar) {
        super((Variable[])ArrayUtils.append(variables, {maxVar}), PropagatorPriority.UNARY, true);
        this.n = variables.length;
        this.x1 = this.solver.getEnvironment().makeInt(-1);
        this.x2 = this.solver.getEnvironment().makeInt(-1);
        assert (this.n > 0);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x1.set(-1);
        this.x2.set(-1);
        for (int i = 0; i < this.n; ++i) {
            if (!((BoolVar[])this.vars)[i].isInstantiated()) {
                if (this.x1.get() == -1) {
                    this.x1.set(i);
                    continue;
                }
                if (this.x2.get() != -1) continue;
                this.x2.set(i);
                continue;
            }
            if (((BoolVar[])this.vars)[i].getValue() != 0 || !((BoolVar[])this.vars)[this.n].instantiateTo(0, this.aCause)) continue;
            this.setPassive();
            return;
        }
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == this.n) {
            this.filter();
        } else if (((BoolVar[])this.vars)[idxVarInProp].isInstantiatedTo(0)) {
            if (((BoolVar[])this.vars)[this.n].instantiateTo(0, this.aCause)) {
                this.setPassive();
            }
        } else if (idxVarInProp == this.x1.get() || idxVarInProp == this.x2.get()) {
            if (idxVarInProp == this.x1.get()) {
                this.x1.set(this.x2.get());
            }
            this.x2.set(-1);
            for (int i = 0; i < this.n; ++i) {
                if (i == this.x1.get() || ((BoolVar[])this.vars)[i].isInstantiated()) continue;
                this.x2.set(i);
                break;
            }
            this.filter();
        }
    }

    public void filter() throws ContradictionException {
        if (this.x1.get() == -1 && ((BoolVar[])this.vars)[this.n].instantiateTo(1, this.aCause)) {
            this.setPassive();
            return;
        }
        if (this.x2.get() == -1 && ((BoolVar[])this.vars)[this.n].isInstantiatedTo(0) && ((BoolVar[])this.vars)[this.x1.get()].instantiateTo(0, this.aCause)) {
            this.setPassive();
            return;
        }
        if (((BoolVar[])this.vars)[this.n].isInstantiatedTo(1)) {
            for (int i = 0; i < this.n; ++i) {
                ((BoolVar[])this.vars)[i].instantiateTo(1, this.aCause);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int lb = ((BoolVar[])this.vars)[this.n].getLB();
        for (i = 0; i < this.n; ++i) {
            if (((BoolVar[])this.vars)[i].getUB() >= lb) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (((BoolVar[])this.vars)[i].getLB() >= lb) continue;
            return ESat.UNDEFINED;
        }
        if (((BoolVar[])this.vars)[this.n].isInstantiated()) {
            for (i = 0; i < this.n; ++i) {
                if (!((BoolVar[])this.vars)[i].isInstantiatedTo(lb)) continue;
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PropBoolMin ");
        sb.append(((BoolVar[])this.vars)[this.n]).append(" = min({");
        sb.append(((BoolVar[])this.vars)[0]);
        for (int i = 1; i < this.n; ++i) {
            sb.append(", ");
            sb.append(((BoolVar[])this.vars)[i]);
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((BoolVar[])this.vars).length - 1;
            BoolVar[] aVars = new BoolVar[size];
            for (int i = 0; i < size; ++i) {
                ((BoolVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (BoolVar)identitymap.get(((BoolVar[])this.vars)[i]);
            }
            ((BoolVar[])this.vars)[size].duplicate(solver, identitymap);
            BoolVar M = (BoolVar)identitymap.get(((BoolVar[])this.vars)[size]);
            identitymap.put(this, new PropBoolMin(aVars, M));
        }
    }
}

