/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropMin
extends Propagator<IntVar> {
    final int n;

    public PropMin(IntVar[] variables, IntVar maxVar) {
        super((Variable[])ArrayUtils.append(variables, {maxVar}), PropagatorPriority.LINEAR, false);
        this.n = variables.length;
        assert (this.n > 0);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        int ub;
        int idx = -1;
        int lb = ub = ((IntVar[])this.vars)[this.n].getUB() + 1;
        for (i = 0; i < this.n; ++i) {
            lb = Math.min(lb, ((IntVar[])this.vars)[i].getLB());
            ub = Math.min(ub, ((IntVar[])this.vars)[i].getUB());
        }
        ((IntVar[])this.vars)[this.n].updateLowerBound(lb, this.aCause);
        ((IntVar[])this.vars)[this.n].updateUpperBound(ub, this.aCause);
        lb = ((IntVar[])this.vars)[this.n].getLB();
        for (i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].getLB() > ub) continue;
            idx = idx == -1 ? i : -2;
            ((IntVar[])this.vars)[i].updateLowerBound(lb, this.aCause);
        }
        if (idx >= 0 && ((IntVar[])this.vars)[idx].updateUpperBound(ub, this.aCause) && lb == ub) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int lb = ((IntVar[])this.vars)[this.n].getLB();
        for (i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].getUB() >= lb) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].getLB() >= lb) continue;
            return ESat.UNDEFINED;
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            for (i = 0; i < this.n; ++i) {
                if (!((IntVar[])this.vars)[i].isInstantiatedTo(lb)) continue;
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PropMin ");
        sb.append(((IntVar[])this.vars)[this.n]).append(" = min({");
        sb.append(((IntVar[])this.vars)[0]);
        for (int i = 1; i < this.n; ++i) {
            sb.append(", ");
            sb.append(((IntVar[])this.vars)[i]);
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar M = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropMin(aVars, M));
        }
    }
}

