/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.nValue.amnv.graph.G;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.F;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAMNV
extends Propagator<IntVar> {
    protected G graph;
    protected F heur;
    protected R[] rules;

    public PropAMNV(IntVar[] X, IntVar N, G graph, F heur, R[] rules) {
        super((Variable[])ArrayUtils.append(X, {N}), PropagatorPriority.CUBIC, true);
        this.graph = graph;
        this.heur = heur;
        this.rules = rules;
        graph.build();
    }

    @Override
    protected int getPropagationConditions(int i) {
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.graph.update();
        }
        this.heur.prepare();
        do {
            this.heur.computeMIS();
            for (R rule : this.rules) {
                rule.filter((IntVar[])this.vars, this.graph, this.heur, this.aCause);
            }
        } while (this.heur.hasNextMIS());
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < ((IntVar[])this.vars).length - 1) {
            this.graph.update(idxVarInProp);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar aVar = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            this.graph.duplicate(solver, identitymap);
            G g = (G)identitymap.get(this.graph);
            this.heur.duplicate(solver, identitymap);
            F h = (F)identitymap.get(this.heur);
            R[] nrules = new R[this.rules.length];
            for (int i = 0; i < nrules.length; ++i) {
                nrules[i] = this.rules[i].duplicate(solver);
            }
            identitymap.put(this, new PropAMNV(aVars, aVar, g, h, nrules));
        }
    }
}

