/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAtLeastNValues
extends Propagator<IntVar> {
    private TIntArrayList concernedValues;
    private int n;
    private int[] mate;
    private boolean allEnum;

    public PropAtLeastNValues(IntVar[] variables, TIntArrayList concernedValues, IntVar nValues) {
        super((Variable[])ArrayUtils.append(variables, {nValues}), PropagatorPriority.QUADRATIC, false);
        this.n = variables.length;
        concernedValues.sort();
        this.concernedValues = concernedValues;
        this.mate = new int[concernedValues.size()];
        this.allEnum = ((IntVar[])this.vars)[0].hasEnumeratedDomain();
        for (int i = 1; i < this.n && this.allEnum; ++i) {
            this.allEnum = ((IntVar[])this.vars)[i].hasEnumeratedDomain();
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        ((IntVar[])this.vars)[this.n].updateUpperBound(this.n, this.aCause);
        int count = 0;
        int countMax = 0;
        for (i = this.concernedValues.size() - 1; i >= 0; --i) {
            boolean possible = false;
            boolean mandatory = false;
            this.mate[i] = -1;
            int value = this.concernedValues.get(i);
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(value)) continue;
                possible = true;
                if (this.mate[i] == -1) {
                    this.mate[i] = v;
                } else {
                    this.mate[i] = -2;
                    if (mandatory) break;
                }
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                if (this.mate[i] == -2) break;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++count;
        }
        ((IntVar[])this.vars)[this.n].updateUpperBound(countMax, this.aCause);
        if (count != countMax && countMax == ((IntVar[])this.vars)[this.n].getLB()) {
            for (i = this.concernedValues.size() - 1; i >= 0; --i) {
                if (this.mate[i] < 0) continue;
                ((IntVar[])this.vars)[this.mate[i]].instantiateTo(this.concernedValues.get(i), this.aCause);
            }
        }
        if (count >= ((IntVar[])this.vars)[this.n].getUB()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        int countMin = 0;
        int countMax = 0;
        for (int i = 0; i < this.concernedValues.size(); ++i) {
            boolean possible = false;
            boolean mandatory = false;
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(this.concernedValues.get(i))) continue;
                possible = true;
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                break;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++countMin;
        }
        if (countMin >= ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.TRUE;
        }
        if (countMax < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar aVar = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropAtLeastNValues(aVars, this.concernedValues, aVar));
        }
    }
}

