/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.differences;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.nValue.amnv.differences.D;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class AutoDiffDetection
implements D {
    public static boolean DYNAMIC_ADDITIONS = false;
    protected Variable[] scope;

    public AutoDiffDetection(Variable[] scope) {
        this.scope = scope;
    }

    @Override
    public boolean mustBeDifferent(int i1, int i2) {
        if (DYNAMIC_ADDITIONS || this.scope[i1].getSolver().getEnvironment().getWorldIndex() <= 1) {
            for (Propagator p : this.scope[i1].getPropagators()) {
                if (!p.isActive() || !p.getClass().getName().contains("PropNotEqualX_Y") && !p.getClass().getName().contains("PropAllDiff")) continue;
                for (Variable v : p.getVars()) {
                    if (v != this.scope[i2]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public D duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        int size = this.scope.length;
        Variable[] aVars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            this.scope[i].duplicate(solver, identitymap);
            aVars[i] = (IntVar)identitymap.get(this.scope[i]);
        }
        return new AutoDiffDetection(aVars);
    }
}

