/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.graph;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.nValue.amnv.graph.G;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class Gi
extends G {
    IntVar[] X;

    public Gi(IntVar[] X) {
        super(X[0].getSolver(), X.length);
        this.X = X;
    }

    @Override
    public void build() {
        int i;
        int n = this.getNbMaxNodes();
        for (i = 0; i < n; ++i) {
            this.getNeighOf(i).clear();
        }
        for (i = 0; i < n; ++i) {
            for (int i2 = i + 1; i2 < n; ++i2) {
                if (!this.intersect(i, i2)) continue;
                this.addEdge(i, i2);
            }
        }
    }

    @Override
    public void update() {
        int n = this.getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            this.update(i);
        }
    }

    @Override
    public void update(int i) {
        ISet nei = this.getNeighOf(i);
        int j = nei.getFirstElement();
        while (j >= 0) {
            if (!this.intersect(i, j)) {
                this.removeEdge(i, j);
            }
            j = nei.getNextElement();
        }
    }

    protected boolean intersect(int i, int j) {
        IntVar x = this.X[i];
        IntVar y = this.X[j];
        if (x.getLB() > y.getUB() || y.getLB() > x.getUB()) {
            return false;
        }
        int ub = x.getUB();
        int val = x.getLB();
        while (val <= ub) {
            if (y.contains(val)) {
                return true;
            }
            val = x.nextValue(val);
        }
        return false;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.X.length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                this.X[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(this.X[i]);
            }
            identitymap.put(this, new Gi(aVars));
        }
    }
}

