/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.mis;

import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.F;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class MD
implements F {
    protected UndirectedGraph graph;
    protected int n;
    protected BitSet out;
    protected BitSet inMIS;
    protected int[] nbNeighbours;
    protected int[] fifo;

    public MD(UndirectedGraph graph) {
        this.graph = graph;
        this.n = graph.getNbMaxNodes();
        this.out = new BitSet(this.n);
        this.inMIS = new BitSet(this.n);
        this.nbNeighbours = new int[this.n];
        this.fifo = new int[this.n];
    }

    @Override
    public void prepare() {
    }

    @Override
    public void computeMIS() {
        this.out.clear();
        this.inMIS.clear();
        for (int i = 0; i < this.n; ++i) {
            this.nbNeighbours[i] = this.graph.getNeighOf(i).getSize();
        }
        int idx = this.out.nextClearBit(0);
        while (idx < this.n) {
            int i = this.out.nextClearBit(idx + 1);
            while (i < this.n) {
                if (this.nbNeighbours[i] < this.nbNeighbours[idx]) {
                    idx = i;
                }
                i = this.out.nextClearBit(i + 1);
            }
            this.addToMIS(idx);
            idx = this.out.nextClearBit(0);
        }
    }

    protected void addToMIS(int node) {
        ISet nei = this.graph.getNeighOf(node);
        this.inMIS.set(node);
        this.out.set(node);
        int sizeFifo = 0;
        int j = nei.getFirstElement();
        while (j >= 0) {
            if (!this.out.get(j)) {
                this.out.set(j);
                this.fifo[sizeFifo++] = j;
            }
            j = nei.getNextElement();
        }
        for (int i = 0; i < sizeFifo; ++i) {
            nei = this.graph.getNeighOf(this.fifo[i]);
            int j2 = nei.getFirstElement();
            while (j2 >= 0) {
                int n = j2;
                this.nbNeighbours[n] = this.nbNeighbours[n] - 1;
                j2 = nei.getNextElement();
            }
        }
    }

    @Override
    public BitSet getMIS() {
        return this.inMIS;
    }

    @Override
    public boolean hasNextMIS() {
        return false;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.graph.duplicate(solver, identitymap);
            UndirectedGraph g = (UndirectedGraph)identitymap.get(this.graph);
            identitymap.put(this, new MD(g));
        }
    }
}

