/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.mis;

import gnu.trove.map.hash.THashMap;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.MD;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.Rk;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class MDRk
extends MD {
    protected int k;
    protected int iter;
    protected Random rd;

    public MDRk(UndirectedGraph graph, int k) {
        super(graph);
        this.k = k;
        this.rd = new Random(0L);
    }

    public MDRk(UndirectedGraph graph) {
        this(graph, Rk.DEFAULT_K);
    }

    @Override
    public void prepare() {
        this.iter = 0;
    }

    @Override
    public void computeMIS() {
        ++this.iter;
        if (this.iter == 1) {
            super.computeMIS();
        } else {
            this.computeMISRk();
        }
    }

    protected void computeMISRk() {
        ++this.iter;
        this.out.clear();
        this.inMIS.clear();
        while (this.out.cardinality() < this.n) {
            int idx;
            int i = idx = this.out.nextClearBit(0);
            for (int nb = this.rd.nextInt(this.n - this.out.cardinality()); i >= 0 && i < this.n && nb >= 0; --nb) {
                idx = i;
                i = this.out.nextClearBit(i + 1);
            }
            this.inMIS.set(idx);
            this.out.set(idx);
            ISet nei = this.graph.getNeighOf(idx);
            int j = nei.getFirstElement();
            while (j >= 0) {
                this.out.set(j);
                j = nei.getNextElement();
            }
        }
    }

    @Override
    public boolean hasNextMIS() {
        return this.iter < this.k;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.graph.duplicate(solver, identitymap);
            UndirectedGraph g = (UndirectedGraph)identitymap.get(this.graph);
            identitymap.put(this, new MDRk(g, this.k));
        }
    }
}

