/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.rules;

import java.util.BitSet;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.F;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class R3
implements R {
    private int n;
    private int[] valToRem;
    private ISet[] learntEqualities;

    public R3(int nbDecVars, Solver solver) {
        this.n = nbDecVars;
        this.valToRem = new int[31];
        this.learntEqualities = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.learntEqualities[i] = SetFactory.makeStoredSet(SetType.BITSET, this.n, solver);
        }
    }

    @Override
    public void filter(IntVar[] vars, UndirectedGraph graph, F heur, Propagator aCause) throws ContradictionException {
        assert (this.n == vars.length - 1);
        BitSet mis = heur.getMIS();
        if (mis.cardinality() == vars[this.n].getUB()) {
            int i = mis.nextClearBit(0);
            while (i >= 0 && i < this.n) {
                int lb;
                int mate = -1;
                int last = 0;
                if (this.valToRem.length < vars[i].getDomainSize()) {
                    this.valToRem = new int[vars[i].getDomainSize() * 2];
                }
                int ub = vars[i].getUB();
                int k = lb = vars[i].getLB();
                while (k <= ub) {
                    this.valToRem[last++] = k;
                    k = vars[i].nextValue(k);
                }
                ISet nei = graph.getNeighOf(i);
                int j = nei.getFirstElement();
                while (j >= 0) {
                    if (mis.get(j)) {
                        if (mate == -1) {
                            mate = j;
                        } else if (mate >= 0) {
                            mate = -2;
                        }
                        for (int ik = 0; ik < last; ++ik) {
                            if (!vars[j].contains(this.valToRem[ik]) || ik >= --last) continue;
                            this.valToRem[ik] = this.valToRem[last];
                            --ik;
                        }
                        if (mate == -2 && last == 0) break;
                    }
                    j = nei.getNextElement();
                }
                if (mate >= 0) {
                    this.enforceEq(i, mate, vars, aCause);
                } else {
                    for (int ik = 0; ik < last; ++ik) {
                        vars[i].removeValue(this.valToRem[ik], aCause);
                    }
                }
                i = mis.nextClearBit(i + 1);
            }
        }
        for (int i = 0; i < this.n; ++i) {
            int j = this.learntEqualities[i].getFirstElement();
            while (j >= 0) {
                this.enforceEq(i, j, vars, aCause);
                j = this.learntEqualities[i].getNextElement();
            }
        }
    }

    protected void enforceEq(int i, int j, IntVar[] vars, Propagator aCause) throws ContradictionException {
        if (i > j) {
            this.enforceEq(j, i, vars, aCause);
        } else {
            this.learntEqualities[i].add(j);
            this.learntEqualities[j].add(i);
            IntVar x = vars[i];
            IntVar y = vars[j];
            while (x.getLB() != y.getLB() || x.getUB() != y.getUB()) {
                x.updateLowerBound(y.getLB(), aCause);
                x.updateUpperBound(y.getUB(), aCause);
                y.updateLowerBound(x.getLB(), aCause);
                y.updateUpperBound(x.getUB(), aCause);
            }
            if (x.hasEnumeratedDomain() && y.hasEnumeratedDomain()) {
                int ub = x.getUB();
                int val = x.getLB();
                while (val <= ub) {
                    if (!y.contains(val)) {
                        x.removeValue(val, aCause);
                    }
                    val = x.nextValue(val);
                }
                ub = y.getUB();
                val = y.getLB();
                while (val <= ub) {
                    if (!x.contains(val)) {
                        y.removeValue(val, aCause);
                    }
                    val = y.nextValue(val);
                }
            }
        }
    }

    @Override
    public R duplicate(Solver solver) {
        return new R3(this.n, solver);
    }
}

