/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nogood;

import org.chocosolver.solver.constraints.nary.nogood.INogood;
import org.chocosolver.solver.constraints.nary.nogood.PropNogoodStore;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class Nogood
implements INogood {
    final IntVar[] vars;
    final int[] wl;
    final int nbvars;
    final int[] values;
    int idxInStore;

    public Nogood(IntVar[] vars, int[] values) {
        this.values = values;
        this.vars = vars;
        this.nbvars = vars.length;
        this.wl = new int[Math.max(this.nbvars, 2)];
        for (int i = 0; i < this.nbvars; ++i) {
            this.wl[i] = i;
        }
    }

    @Override
    public void setIdx(int idx) {
        this.idxInStore = idx;
    }

    @Override
    public int getIdx() {
        return this.idxInStore;
    }

    public boolean findLiteral(int start) {
        for (int i = start; i < this.nbvars; ++i) {
            int k = this.wl[i];
            if (this.vars[k].contains(this.values[k])) {
                if (this.vars[k].isInstantiated()) continue;
                int lwl = this.wl[start];
                this.wl[start] = this.wl[i];
                this.wl[i] = lwl;
                break;
            }
            return false;
        }
        return true;
    }

    @Override
    public int propagate(PropNogoodStore pngs) throws ContradictionException {
        if (!this.findLiteral(0)) {
            return -1;
        }
        if (this.vars[this.wl[0]].isInstantiatedTo(this.values[this.wl[0]])) {
            pngs.contradiction(null, "Inconsistent");
        }
        this.findLiteral(1);
        if (this.vars[this.wl[1]].isInstantiatedTo(this.values[this.wl[1]])) {
            int k = this.wl[0];
            if (this.vars[k].removeValue(this.values[k], pngs)) {
                return this.vars[k].isInstantiated() ? k : -1;
            }
            pngs.watch(this.vars[k], this, k);
        } else {
            pngs.watch(this.vars[this.wl[0]], this, this.wl[0]);
            pngs.watch(this.vars[this.wl[1]], this, this.wl[1]);
        }
        return -1;
    }

    @Override
    public int awakeOnInst(int idx, PropNogoodStore pngs) throws ContradictionException {
        assert (this.vars[idx].isInstantiated());
        if (!this.vars[idx].contains(this.values[idx])) {
            return -1;
        }
        if (this.wl[0] == idx) {
            this.wl[0] = this.wl[1];
            this.wl[1] = idx;
        }
        if (!this.vars[this.wl[0]].contains(this.values[this.wl[0]])) {
            return -1;
        }
        for (int i = 2; i < this.wl.length; ++i) {
            int k = this.wl[i];
            if (this.vars[k].contains(this.values[k])) {
                if (this.vars[k].isInstantiated()) continue;
                this.wl[1] = this.wl[i];
                this.wl[i] = idx;
                pngs.unwatch(this.vars[idx], this);
                pngs.watch(this.vars[this.wl[1]], this, this.wl[1]);
                return -99;
            }
            return -1;
        }
        if (this.vars[this.wl[0]].removeValue(this.values[this.wl[0]], pngs)) {
            return this.vars[this.wl[0]].isInstantiated() ? this.wl[0] : -1;
        }
        return -1;
    }

    @Override
    public boolean isUnit() {
        return false;
    }

    @Override
    public ESat isEntailed() {
        int c = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].contains(this.values[i])) {
                if (!this.vars[i].isInstantiated()) continue;
                ++c;
                continue;
            }
            return ESat.TRUE;
        }
        return c == this.vars.length ? ESat.FALSE : ESat.UNDEFINED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nbvars; ++i) {
            sb.append(this.vars[i].getName()).append("==").append(this.values[i]).append(',');
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.vars.length;
    }

    @Override
    public IntVar getVar(int i) {
        return this.vars[i];
    }

    @Override
    public int getVal(int i) {
        return this.values[i];
    }
}

