/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nogood;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.nogood.INogood;
import org.chocosolver.solver.constraints.nary.nogood.Nogood;
import org.chocosolver.solver.constraints.nary.nogood.PropNogoodStore;
import org.chocosolver.solver.constraints.nary.nogood.UnitNogood;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.queues.CircularQueue;

public class NogoodStoreFromRestarts
extends Constraint
implements IMonitorRestart {
    static final String MSG_NGOOD = "unit propagation failure (nogood)";
    CircularQueue<Decision<IntVar>> decisions;
    CircularQueue<INogood> nogoods;
    final PropNogoodStore png;

    public NogoodStoreFromRestarts(IntVar[] vars) {
        super("NogoodStoreFromRestarts", new PropNogoodStore(vars));
        this.png = (PropNogoodStore)this.propagators[0];
        this.decisions = new CircularQueue(16);
        this.nogoods = new CircularQueue(16);
    }

    @Override
    public void beforeRestart() {
        this.extractNogoodFromPath();
    }

    @Override
    public void afterRestart() {
        try {
            while (!this.nogoods.isEmpty()) {
                INogood ng = this.nogoods.pollFirst();
                this.png.addNogood(ng);
            }
            this.png.unitPropagation();
            this.png.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e) {
            this.png.getSolver().getSearchLoop().interrupt(MSG_NGOOD);
        }
    }

    private void extractNogoodFromPath() {
        Decision<IntVar> decision;
        int d = this.png.getSolver().getSearchLoop().getCurrentDepth();
        for (decision = this.png.getSolver().getSearchLoop().getLastDecision(); decision != RootDecision.ROOT; decision = decision.getPrevious()) {
            this.decisions.addLast(decision);
        }
        IntVar[] vars = new IntVar[d];
        int[] values = new int[d];
        int i = 0;
        while (!this.decisions.isEmpty()) {
            INogood ng;
            decision = this.decisions.pollLast();
            assert (decision instanceof FastDecision) : "NogoodStoreFromRestarts is only valid for integer variables (hence FastDecision)";
            assert (decision.toString().contains(DecisionOperator.int_eq.toString())) : "NogoodStoreFromRestarts is only valid for assignment decisions";
            if (decision.hasNext()) {
                vars[i] = decision.getDecisionVariable();
                values[i] = (Integer)decision.getDecisionValue();
                ++i;
                continue;
            }
            if (i == 0) {
                ng = new UnitNogood(decision.getDecisionVariable(), (Integer)decision.getDecisionValue());
            } else {
                vars[i] = decision.getDecisionVariable();
                values[i] = (Integer)decision.getDecisionValue();
                ng = new Nogood(Arrays.copyOf(vars, i + 1), Arrays.copyOf(values, i + 1));
            }
            this.nogoods.addLast(ng);
        }
    }
}

