/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nogood;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.nogood.INogood;
import org.chocosolver.solver.constraints.nary.nogood.Nogood;
import org.chocosolver.solver.constraints.nary.nogood.PropNogoodStore;
import org.chocosolver.solver.constraints.nary.nogood.UnitNogood;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.variables.IntVar;

public class NogoodStoreFromSolutions
extends Constraint
implements IMonitorSolution,
IMonitorRestart {
    static final String MSG_NGOOD = "unit propagation failure (nogood from solution)";
    INogood solutionNoGood;
    final PropNogoodStore png;
    protected final IntVar[] decisionVars;

    public NogoodStoreFromSolutions(IntVar[] vars) {
        super("NogoodStoreFromSolutions", new PropNogoodStore(vars));
        this.decisionVars = vars;
        this.png = (PropNogoodStore)this.propagators[0];
    }

    @Override
    public void onSolution() {
        this.extractNogoodFromPath();
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        try {
            this.png.addNogood(this.solutionNoGood);
            this.png.unitPropagation();
            this.png.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e) {
            this.png.getSolver().getSearchLoop().interrupt(MSG_NGOOD);
        }
    }

    private void extractNogoodFromPath() {
        int n = this.decisionVars.length;
        if (n == 1) {
            this.solutionNoGood = new UnitNogood(this.decisionVars[0], this.decisionVars[0].getValue());
        } else {
            int[] values = new int[n];
            for (int i = 0; i < n; ++i) {
                values[i] = this.decisionVars[i].getValue();
            }
            this.solutionNoGood = new Nogood(this.decisionVars, values);
        }
    }
}

