/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nogood;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.nogood.INogood;
import org.chocosolver.solver.constraints.nary.nogood.Nogood;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.queues.CircularQueue;

public class PropNogoodStore
extends Propagator<IntVar> {
    List<INogood> units;
    List<INogood> allnogoods;
    TIntObjectHashMap<TIntList> vars2nogood = new TIntObjectHashMap();
    TIntObjectHashMap<TIntList> vars2idxinng = new TIntObjectHashMap();
    CircularQueue<IntVar> hasChanged;

    public PropNogoodStore(IntVar[] vars) {
        super((Variable[])vars, PropagatorPriority.VERY_SLOW, true);
        this.allnogoods = new ArrayList<INogood>();
        this.units = new ArrayList<INogood>();
        this.hasChanged = new CircularQueue(8);
    }

    @Override
    public boolean advise(int idxVarInProp, int mask) {
        return super.advise(idxVarInProp, mask) && this.vars2nogood.get(((IntVar[])this.vars)[idxVarInProp].getId()) != null;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (INogood ng : this.allnogoods) {
            ng.propagate(this);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.hasChanged.clear();
        this.hasChanged.addLast(((IntVar[])this.vars)[idxVarInProp]);
        while (!this.hasChanged.isEmpty()) {
            IntVar var = this.hasChanged.pollFirst();
            TIntList nogoods = this.vars2nogood.get(var.getId());
            TIntList indices = this.vars2idxinng.get(var.getId());
            for (int i = 0; i < nogoods.size(); ++i) {
                INogood ng = this.allnogoods.get(nogoods.get(i));
                int idx = ng.awakeOnInst(indices.get(i), this);
                if (idx > -1) {
                    this.hasChanged.addLast(ng.getVar(idx));
                    continue;
                }
                if (idx == -99) {
                    --i;
                    continue;
                }
                assert (ng.isEntailed() != ESat.FALSE);
            }
        }
    }

    public void unitPropagation() throws ContradictionException {
        for (INogood ng : this.units) {
            ng.propagate(this);
        }
    }

    @Override
    public ESat isEntailed() {
        for (INogood ng : this.allnogoods) {
            ESat sat = ng.isEntailed();
            if (sat.equals((Object)ESat.TRUE)) continue;
            return sat;
        }
        return ESat.TRUE;
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        if (d != null && d.getmType() == Deduction.Type.ValRem) {
            ValueRemoval vr = (ValueRemoval)d;
            IntVar var = (IntVar)vr.getVar();
            int val = vr.getVal();
            TIntList nogoods = this.vars2nogood.get(var.getId());
            TIntList indices = this.vars2idxinng.get(var.getId());
            for (int i = 0; i < nogoods.size(); ++i) {
                int idx;
                INogood ng = this.allnogoods.get(nogoods.get(i));
                if (val != ng.getVal(idx = indices.get(i))) continue;
                for (int j = 0; j < ng.size(); ++j) {
                    if (ng.getVar(j) == var) continue;
                    ng.getVar(j).explain(xengine, VariableState.DOM, e);
                }
            }
        } else {
            super.explain(xengine, d, e);
        }
    }

    public void addNogood(INogood ng) throws ContradictionException {
        if (ng.isUnit()) {
            this.units.add(ng);
        }
        int ngidx = this.allnogoods.size();
        this.allnogoods.add(ng);
        ng.setIdx(ngidx);
        this.hasChanged.clear();
        int idx = ng.propagate(this);
        if (idx > -1) {
            this.hasChanged.addLast(ng.getVar(idx));
        }
        while (!this.hasChanged.isEmpty()) {
            IntVar var = this.hasChanged.pollFirst();
            TIntList nogoods = this.vars2nogood.get(var.getId());
            TIntList indices = this.vars2idxinng.get(var.getId());
            for (int i = 0; i < nogoods.size(); ++i) {
                ng = this.allnogoods.get(nogoods.get(i));
                idx = ng.awakeOnInst(indices.get(i), this);
                if (idx > -1) {
                    this.hasChanged.addLast(ng.getVar(idx));
                    continue;
                }
                assert (ng.isEntailed() != ESat.FALSE);
            }
        }
    }

    public void watch(IntVar var, Nogood ng, int idxInNG) {
        TIntList nogoods = this.vars2nogood.get(var.getId());
        if (nogoods == null) {
            nogoods = new TIntArrayList();
            this.vars2nogood.put(var.getId(), nogoods);
        }
        nogoods.add(ng.getIdx());
        TIntList indices = this.vars2idxinng.get(var.getId());
        if (indices == null) {
            indices = new TIntArrayList();
            this.vars2idxinng.put(var.getId(), indices);
        }
        indices.add(idxInNG);
    }

    public void unwatch(IntVar var, Nogood ng) {
        int ni;
        TIntList nogoods = this.vars2nogood.get(var.getId());
        if (nogoods != null && (ni = nogoods.indexOf(ng.getIdx())) > -1) {
            nogoods.removeAt(ni);
            TIntList indices = this.vars2idxinng.get(var.getId());
            indices.removeAt(ni);
        }
    }
}

