/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nogood;

import org.chocosolver.solver.constraints.nary.nogood.INogood;
import org.chocosolver.solver.constraints.nary.nogood.PropNogoodStore;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class UnitNogood
implements INogood {
    final IntVar var;
    final int value;
    int idxInStore;

    public UnitNogood(IntVar var, int value) {
        this.value = value;
        this.var = var;
    }

    @Override
    public void setIdx(int idx) {
        this.idxInStore = idx;
    }

    @Override
    public int getIdx() {
        return this.idxInStore;
    }

    @Override
    public int propagate(PropNogoodStore pngs) throws ContradictionException {
        this.var.removeValue(this.value, pngs);
        return -1;
    }

    @Override
    public int awakeOnInst(int idx, PropNogoodStore pngs) throws ContradictionException {
        this.var.removeValue(this.value, pngs);
        return -1;
    }

    @Override
    public boolean isUnit() {
        return true;
    }

    @Override
    public ESat isEntailed() {
        if (this.var.contains(this.value)) {
            if (this.var.isInstantiated()) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    public String toString() {
        return this.var.getName() + "==" + this.value + ',';
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public IntVar getVar(int i) {
        if (i == 0) {
            return this.var;
        }
        return null;
    }

    @Override
    public int getVal(int i) {
        if (i == 0) {
            return this.value;
        }
        return Integer.MAX_VALUE;
    }
}

