/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolSumCoarse
extends Propagator<IntVar> {
    IntVar sum;
    int n;
    int min;
    int max;

    public PropBoolSumCoarse(BoolVar[] variables, IntVar sum) {
        super((Variable[])ArrayUtils.append(variables, {sum}), PropagatorPriority.UNARY, false);
        this.n = variables.length;
        this.sum = ((IntVar[])this.vars)[this.n];
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.min = 0;
        this.max = 0;
        for (int i = 0; i < this.n; ++i) {
            this.min += ((IntVar[])this.vars)[i].getLB();
            this.max += ((IntVar[])this.vars)[i].getUB();
        }
        this.filter();
    }

    private void filter() throws ContradictionException {
        this.sum.updateLowerBound(this.min, this.aCause);
        this.sum.updateUpperBound(this.max, this.aCause);
        if (this.min != this.max && this.sum.isInstantiated()) {
            int i;
            if (this.sum.getValue() == this.min) {
                for (i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ((IntVar[])this.vars)[i].instantiateTo(0, this.aCause);
                }
            }
            if (this.sum.getValue() == this.max) {
                for (i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ((IntVar[])this.vars)[i].instantiateTo(1, this.aCause);
                }
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.instantiation();
    }

    @Override
    public ESat isEntailed() {
        int lb = 0;
        int ub = 0;
        for (int i = 0; i < this.n; ++i) {
            lb += ((IntVar[])this.vars)[i].getLB();
            ub += ((IntVar[])this.vars)[i].getUB();
        }
        if (lb > this.sum.getUB() || ub < this.sum.getLB()) {
            return ESat.FALSE;
        }
        if (lb == ub && this.sum.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropBoolSumCoarse(");
        for (int i = 0; i < ((IntVar[])this.vars).length - 2; ++i) {
            sb.append(((IntVar[])this.vars)[i]).append("+");
        }
        sb.append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 2]).append(")");
        sb.append(" = ").append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1]);
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            BoolVar[] aVars = new BoolVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (BoolVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar S = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropBoolSumCoarse(aVars, S));
        }
    }
}

