/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolSumIncremental
extends Propagator<IntVar> {
    IntVar sum;
    int n;
    IStateInt min;
    IStateInt max;

    public PropBoolSumIncremental(BoolVar[] variables, IntVar sum) {
        super((Variable[])ArrayUtils.append(variables, {sum}), PropagatorPriority.UNARY, true);
        this.n = variables.length;
        this.sum = ((IntVar[])this.vars)[this.n];
        IEnvironment environment = this.solver.getEnvironment();
        this.min = environment.makeInt();
        this.max = environment.makeInt();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int lb = 0;
        int ub = 0;
        for (int i = 0; i < this.n; ++i) {
            lb += ((IntVar[])this.vars)[i].getLB();
            ub += ((IntVar[])this.vars)[i].getUB();
        }
        this.min.set(lb);
        this.max.set(ub);
        this.filter();
    }

    private void filter() throws ContradictionException {
        int lb = this.min.get();
        int ub = this.max.get();
        this.sum.updateLowerBound(lb, this.aCause);
        this.sum.updateUpperBound(ub, this.aCause);
        if (lb != ub && this.sum.isInstantiated()) {
            int i;
            if (this.sum.getValue() == lb) {
                for (i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ((IntVar[])this.vars)[i].instantiateTo(0, this.aCause);
                }
            }
            if (this.sum.getValue() == ub) {
                for (i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ((IntVar[])this.vars)[i].instantiateTo(1, this.aCause);
                }
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.n) {
            if (((IntVar[])this.vars)[idxVarInProp].getValue() == 1) {
                this.min.add(1);
            } else {
                this.max.add(-1);
            }
        }
        this.filter();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.instantiation();
    }

    @Override
    public ESat isEntailed() {
        int lb = 0;
        int ub = 0;
        for (int i = 0; i < this.n; ++i) {
            lb += ((IntVar[])this.vars)[i].getLB();
            ub += ((IntVar[])this.vars)[i].getUB();
        }
        if (lb > this.sum.getUB() || ub < this.sum.getLB()) {
            return ESat.FALSE;
        }
        if (lb == ub && this.sum.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropBoolSumIncremental(");
        for (int i = 0; i < ((IntVar[])this.vars).length - 2; ++i) {
            sb.append(((IntVar[])this.vars)[i]).append("+");
        }
        sb.append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 2]).append(")");
        sb.append(" = ").append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1]);
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            BoolVar[] aVars = new BoolVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (BoolVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar S = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropBoolSumIncremental(aVars, S));
        }
    }
}

