/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropScalarEq
extends Propagator<IntVar> {
    final int[] c;
    final int pos;
    final int l;
    final int b;
    final int[] I;
    int sumLB;
    int sumUB;

    protected static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 1) {
            return PropagatorPriority.UNARY;
        }
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    public PropScalarEq(IntVar[] variables, int[] coeffs, int pos, int b) {
        super((Variable[])variables, PropScalarEq.computePriority(variables.length), false);
        this.c = coeffs;
        this.pos = pos;
        this.l = variables.length;
        this.b = b;
        this.I = new int[this.l];
    }

    protected void prepare() {
        int ub;
        int lb;
        int i;
        int f = 0;
        int e = 0;
        for (i = 0; i < this.pos; ++i) {
            lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            f += lb;
            e += ub;
            this.I[i] = ub - lb;
        }
        while (i < this.l) {
            lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            f += lb;
            e += ub;
            this.I[i] = ub - lb;
            ++i;
        }
        this.sumLB = f;
        this.sumUB = e;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter(true, 2);
    }

    protected void filter(boolean startWithLeq, int nbRules) throws ContradictionException {
        boolean run;
        this.prepare();
        int nbR = 0;
        do {
            run = startWithLeq ? this.filterOnLeq() : this.filterOnGeq();
            startWithLeq ^= true;
        } while (run || ++nbR < nbRules);
        this.checkEntailment();
    }

    protected void checkEntailment() {
        if (this.sumUB - this.b <= 0 && this.sumLB - this.b >= 0) {
            this.setPassive();
        }
    }

    boolean filterOnLeq() throws ContradictionException {
        int nub;
        int ub;
        int lb;
        int i;
        boolean anychange = false;
        if (this.b - this.sumLB < 0) {
            this.contradiction(null, "b - sumLB < 0");
        }
        for (i = 0; i < this.pos; ++i) {
            if (this.I[i] - (this.b - this.sumLB) <= 0) continue;
            lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ub = lb + this.I[i];
            if (!((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(this.b - this.sumLB + lb, this.c[i]), this.aCause)) continue;
            nub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            this.sumUB -= ub - nub;
            this.I[i] = nub - lb;
            anychange = true;
        }
        while (i < this.l) {
            if (this.I[i] - (this.b - this.sumLB) > 0) {
                lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                ub = lb + this.I[i];
                if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-(this.b - this.sumLB + lb), -this.c[i]), this.aCause)) {
                    nub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                    this.sumUB -= ub - nub;
                    this.I[i] = nub - lb;
                    anychange = true;
                }
            }
            ++i;
        }
        return anychange;
    }

    boolean filterOnGeq() throws ContradictionException {
        int nlb;
        int lb;
        int ub;
        int i;
        boolean anychange = false;
        if (this.b - this.sumUB > 0) {
            this.contradiction(null, "b - sumUB > 0");
        }
        for (i = 0; i < this.pos; ++i) {
            if (this.I[i] <= -(this.b - this.sumUB)) continue;
            ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            lb = ub - this.I[i];
            if (!((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(this.b - this.sumUB + ub, this.c[i]), this.aCause)) continue;
            nlb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            this.sumLB += nlb - lb;
            this.I[i] = ub - nlb;
            anychange = true;
        }
        while (i < this.l) {
            if (this.I[i] > -(this.b - this.sumUB)) {
                ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                lb = ub - this.I[i];
                if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-(this.b - this.sumUB + ub), -this.c[i]), this.aCause)) {
                    nlb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                    this.sumLB += nlb - lb;
                    this.I[i] = ub - nlb;
                    anychange = true;
                }
            }
            ++i;
        }
        return anychange;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int i;
        int sumUB = 0;
        int sumLB = 0;
        for (i = 0; i < this.pos; ++i) {
            sumLB += ((IntVar[])this.vars)[i].getLB() * this.c[i];
            sumUB += ((IntVar[])this.vars)[i].getUB() * this.c[i];
        }
        while (i < this.l) {
            sumLB += ((IntVar[])this.vars)[i].getUB() * this.c[i];
            sumUB += ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ++i;
        }
        return this.compare(sumLB, sumUB);
    }

    protected ESat compare(int sumLB, int sumUB) {
        if (sumUB == this.b && sumLB == this.b) {
            return ESat.TRUE;
        }
        if (sumLB > this.b || sumUB < this.b) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(((IntVar[])this.vars)[0].getName()).append('.').append(this.c[0]);
        for (int i = 1; i < this.l; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName()).append('.').append(this.c[i]);
        }
        linComb.append(" = ");
        linComb.append(this.b);
        return linComb.toString();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        if (d != null && d.getmType() == Deduction.Type.ValRem) {
            boolean ispos;
            int i;
            ValueRemoval vr = (ValueRemoval)d;
            IntVar var = (IntVar)vr.getVar();
            int val = vr.getVal();
            if (this.pos < this.l / 2) {
                for (i = 0; i < this.pos && ((IntVar[])this.vars)[i].getId() != var.getId(); ++i) {
                }
                ispos = i < this.pos;
            } else {
                for (i = this.pos; i < this.l && ((IntVar[])this.vars)[i].getId() != var.getId(); ++i) {
                }
                boolean bl = ispos = i == this.l;
            }
            if (val < var.getLB()) {
                for (i = 0; i < this.pos; ++i) {
                    if (((IntVar[])this.vars)[i] == var) continue;
                    ((IntVar[])this.vars)[i].explain(xengine, ispos ? VariableState.UB : VariableState.LB, e);
                }
                while (i < this.l) {
                    if (((IntVar[])this.vars)[i] != var) {
                        ((IntVar[])this.vars)[i].explain(xengine, ispos ? VariableState.LB : VariableState.UB, e);
                    }
                    ++i;
                }
            } else if (val > var.getUB()) {
                for (i = 0; i < this.pos; ++i) {
                    if (((IntVar[])this.vars)[i] == var) continue;
                    ((IntVar[])this.vars)[i].explain(xengine, ispos ? VariableState.LB : VariableState.UB, e);
                }
                while (i < this.l) {
                    if (((IntVar[])this.vars)[i] != var) {
                        ((IntVar[])this.vars)[i].explain(xengine, ispos ? VariableState.UB : VariableState.LB, e);
                    }
                    ++i;
                }
            } else {
                super.explain(xengine, d, e);
            }
        } else {
            super.explain(xengine, d, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropScalarEq(aVars, this.c, this.pos, this.b));
        }
    }

    private int divFloor(int a, int b) {
        if (a >= 0) {
            return a / b;
        }
        return (a - b + 1) / b;
    }

    private int divCeil(int a, int b) {
        if (a >= 0) {
            return (a + b - 1) / b;
        }
        return a / b;
    }
}

