/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSumEq
extends Propagator<IntVar> {
    final int n;

    protected static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 1) {
            return PropagatorPriority.UNARY;
        }
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    public PropSumEq(IntVar[] variables, IntVar sum) {
        super((Variable[])ArrayUtils.append(variables, {sum}), PropSumEq.computePriority(variables.length), false);
        this.n = variables.length;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean again;
        do {
            int i;
            int min = 0;
            int max = 0;
            int ampMax = 0;
            for (int i2 = 0; i2 < this.n; ++i2) {
                min += ((IntVar[])this.vars)[i2].getLB();
                max += ((IntVar[])this.vars)[i2].getUB();
                ampMax = Math.max(((IntVar[])this.vars)[i2].getUB() - ((IntVar[])this.vars)[i2].getLB(), ampMax);
            }
            ((IntVar[])this.vars)[this.n].updateLowerBound(min, this.aCause);
            ((IntVar[])this.vars)[this.n].updateUpperBound(max, this.aCause);
            int lb = ((IntVar[])this.vars)[this.n].getLB();
            int ub = ((IntVar[])this.vars)[this.n].getUB();
            again = false;
            if (min + ampMax > ub) {
                for (i = 0; i < this.n; ++i) {
                    again |= ((IntVar[])this.vars)[i].updateUpperBound(ub - min + ((IntVar[])this.vars)[i].getLB(), this.aCause);
                }
            }
            if (max - ampMax >= lb) continue;
            for (i = 0; i < this.n; ++i) {
                again |= ((IntVar[])this.vars)[i].updateLowerBound(lb - max + ((IntVar[])this.vars)[i].getUB(), this.aCause);
            }
        } while (again);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public final ESat isEntailed() {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            min += ((IntVar[])this.vars)[i].getLB();
            max += ((IntVar[])this.vars)[i].getUB();
        }
        if (max < ((IntVar[])this.vars)[this.n].getLB() || min > ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.FALSE;
        }
        if (min == max && ((IntVar[])this.vars)[this.n].isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(((IntVar[])this.vars)[0].getName());
        for (int i = 1; i < this.n; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName());
        }
        linComb.append(" = ");
        linComb.append(((IntVar[])this.vars)[this.n].getName());
        return linComb.toString();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        if (d != null && d.getmType() == Deduction.Type.ValRem) {
            boolean ispos;
            ValueRemoval vr = (ValueRemoval)d;
            IntVar var = (IntVar)vr.getVar();
            int val = vr.getVal();
            boolean bl = ispos = ((IntVar[])this.vars)[this.n].getId() != var.getId();
            if (val < var.getLB()) {
                for (int i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i] == var) continue;
                    ((IntVar[])this.vars)[i].explain(xengine, ispos ? VariableState.UB : VariableState.LB, e);
                }
                if (((IntVar[])this.vars)[this.n] != var) {
                    ((IntVar[])this.vars)[this.n].explain(xengine, ispos ? VariableState.LB : VariableState.UB, e);
                }
            } else if (val > var.getUB()) {
                for (int i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i] == var) continue;
                    ((IntVar[])this.vars)[i].explain(xengine, ispos ? VariableState.LB : VariableState.UB, e);
                }
                if (((IntVar[])this.vars)[this.n] != var) {
                    ((IntVar[])this.vars)[this.n].explain(xengine, ispos ? VariableState.UB : VariableState.LB, e);
                }
            } else {
                super.explain(xengine, d, e);
            }
        } else {
            super.explain(xengine, d, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar S = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropSumEq(aVars, S));
        }
    }
}

