/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.sum.PropScalarEq;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class Scalar
extends Constraint {
    public Scalar(IntVar[] X, int[] A, int B) {
        super("Scalar", Scalar.makeProp(X, A, B));
    }

    public Scalar(IntVar[] X, int[] A, IntVar Y, int B) {
        this(ArrayUtils.append(X, {Y}), ArrayUtils.append(A, {-B}), 0);
    }

    private static Propagator<IntVar> makeProp(IntVar[] vars, int[] coeffs, int result) {
        TObjectIntHashMap<IntVar> map = new TObjectIntHashMap<IntVar>();
        for (int i = 0; i < vars.length; ++i) {
            map.adjustOrPutValue(vars[i], coeffs[i], coeffs[i]);
            if (map.get(vars[i]) != 0) continue;
            map.remove(vars[i]);
        }
        int b = 0;
        int e = map.size();
        IntVar[] tmpV = new IntVar[e];
        int[] tmpC = new int[e];
        for (int i = 0; i < vars.length; ++i) {
            IntVar key = vars[i];
            int coeff = map.get(key);
            if (coeff > 0) {
                tmpV[b] = key;
                tmpC[b++] = coeff;
            } else if (coeff < 0) {
                tmpV[--e] = key;
                tmpC[e] = coeff;
            }
            map.adjustValue(key, -coeff);
        }
        return new PropScalarEq(tmpV, tmpC, b, result);
    }

    public static int[] getScalarBounds(IntVar[] vars, int[] coefs) {
        int[] ext = new int[2];
        for (int i = 0; i < vars.length; ++i) {
            int min = Math.min(0, vars[i].getLB() * coefs[i]);
            min = Math.min(min, vars[i].getUB() * coefs[i]);
            int max = Math.max(0, vars[i].getLB() * coefs[i]);
            max = Math.max(max, vars[i].getUB() * coefs[i]);
            ext[0] = ext[0] + min;
            ext[1] = ext[1] + max;
        }
        return ext;
    }
}

