/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.IntConstraintFactory;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.constraints.nary.sum.PropSumEq;
import org.chocosolver.solver.constraints.nary.sum.Scalar;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.StringUtils;

public class ScalarFactory {
    private ScalarFactory() {
    }

    public static Constraint reduce(IntVar[] VARS, String OPERATOR, IntVar SUM) {
        if (VARS.length == 1) {
            if (SUM.isInstantiated()) {
                return IntConstraintFactory.arithm(VARS[0], OPERATOR, SUM.getValue());
            }
            return IntConstraintFactory.arithm(VARS[0], OPERATOR, SUM);
        }
        if (VARS.length == 2 && SUM.isInstantiated()) {
            return IntConstraintFactory.arithm(VARS[0], "+", VARS[1], OPERATOR, SUM.getValue());
        }
        int nbBools = 0;
        for (IntVar left : VARS) {
            if ((left.getTypeAndKind() & 0xF8) != 24) continue;
            ++nbBools;
        }
        if (nbBools == VARS.length) {
            BoolVar[] bvars = new BoolVar[nbBools];
            for (int i = 0; i < nbBools; ++i) {
                bvars[i] = (BoolVar)VARS[i];
            }
            return IntConstraintFactory.sum(bvars, OPERATOR, SUM);
        }
        if (OPERATOR.equals("=")) {
            return new Constraint("Sum", new PropSumEq(VARS, SUM));
        }
        int lb = 0;
        int ub = 0;
        for (IntVar v : VARS) {
            lb += v.getLB();
            ub += v.getUB();
        }
        IntVar p = VF.bounded(StringUtils.randomName(), lb, ub, SUM.getSolver());
        SUM.getSolver().post(new Constraint("Sum", new PropSumEq(VARS, p)));
        return IntConstraintFactory.arithm(p, OPERATOR, SUM);
    }

    public static Constraint reduce(IntVar[] VARS, int[] COEFFS, String OPERATOR, IntVar SCALAR) {
        if (VARS.length == 0) {
            return IntConstraintFactory.arithm(VF.fixed(0, SCALAR.getSolver()), OPERATOR, SCALAR);
        }
        if (COEFFS.length == 2 && SCALAR.isInstantiated()) {
            int c = SCALAR.getValue();
            if (COEFFS[0] == 1 && COEFFS[1] == 1) {
                return IntConstraintFactory.arithm(VARS[0], "+", VARS[1], OPERATOR, c);
            }
            if (COEFFS[0] == 1 && COEFFS[1] == -1) {
                return IntConstraintFactory.arithm(VARS[0], "-", VARS[1], OPERATOR, c);
            }
            if (COEFFS[0] == -1 && COEFFS[1] == 1) {
                return IntConstraintFactory.arithm(VARS[1], "-", VARS[0], OPERATOR, c);
            }
            if (COEFFS[0] == -1 && COEFFS[1] == -1) {
                return IntConstraintFactory.arithm(VARS[0], "+", VARS[1], Operator.getFlip(OPERATOR), -c);
            }
        }
        int n = VARS.length;
        int nbOne = 0;
        int nbMinusOne = 0;
        int nbZero = 0;
        for (int i = 0; i < n; ++i) {
            if (COEFFS[i] == 1) {
                ++nbOne;
                continue;
            }
            if (COEFFS[i] == -1) {
                ++nbMinusOne;
                continue;
            }
            if (COEFFS[i] != 0) continue;
            ++nbZero;
        }
        if (nbZero > 0) {
            IntVar[] nonZerosVars = new IntVar[n - nbZero];
            int[] nonZerosCoefs = new int[n - nbZero];
            int k = 0;
            for (int i = 0; i < n; ++i) {
                if (COEFFS[i] == 0) continue;
                nonZerosVars[k] = VARS[i];
                nonZerosCoefs[k] = COEFFS[i];
                ++k;
            }
            return IntConstraintFactory.scalar(nonZerosVars, nonZerosCoefs, OPERATOR, SCALAR);
        }
        if (nbOne + nbMinusOne == n) {
            if (nbOne == n) {
                return IntConstraintFactory.sum(VARS, OPERATOR, SCALAR);
            }
            if (nbMinusOne == n) {
                return IntConstraintFactory.sum(VARS, Operator.getFlip(OPERATOR), VF.minus(SCALAR));
            }
            if (SCALAR.isInstantiated()) {
                if (nbMinusOne == 1) {
                    IntVar[] v2 = new IntVar[n - 1];
                    IntVar s2 = null;
                    int k = 0;
                    for (int i = 0; i < n; ++i) {
                        if (COEFFS[i] != -1) {
                            v2[k++] = VARS[i];
                            continue;
                        }
                        s2 = VARS[i];
                    }
                    return IntConstraintFactory.sum(v2, OPERATOR, VF.offset(s2, SCALAR.getValue()));
                }
                if (nbOne == 1) {
                    IntVar[] v2 = new IntVar[n - 1];
                    IntVar s2 = null;
                    int k = 0;
                    for (int i = 0; i < n; ++i) {
                        if (COEFFS[i] != 1) {
                            v2[k++] = VARS[i];
                            continue;
                        }
                        s2 = VARS[i];
                    }
                    return IntConstraintFactory.sum(v2, Operator.getFlip(OPERATOR), VF.offset(s2, -SCALAR.getValue()));
                }
            } else if (n == 2) {
                if (COEFFS[0] == 1) {
                    assert (COEFFS[1] == -1);
                    return IntConstraintFactory.sum(new IntVar[]{VARS[1], SCALAR}, Operator.getFlip(OPERATOR), VARS[0]);
                }
                assert (COEFFS[0] == -1);
                assert (COEFFS[1] == 1);
                return IntConstraintFactory.sum(new IntVar[]{VARS[0], SCALAR}, Operator.getFlip(OPERATOR), VARS[1]);
            }
        }
        if (OPERATOR.equals("=")) {
            return ScalarFactory.makeScalar(VARS, COEFFS, SCALAR, 1);
        }
        int[] b = Scalar.getScalarBounds(VARS, COEFFS);
        Solver s = VARS[0].getSolver();
        IntVar p = VF.bounded(StringUtils.randomName(), b[0], b[1], s);
        s.post(ScalarFactory.makeScalar(VARS, COEFFS, p, 1));
        return IntConstraintFactory.arithm(p, OPERATOR, SCALAR);
    }

    private static Constraint makeScalar(IntVar[] VARS, int[] COEFFS, IntVar SCALAR, int SCALAR_COEF) {
        int maxDomSize = SCALAR.getDomainSize();
        int idx = -1;
        int n = VARS.length;
        int nbBools = 0;
        for (int i = 0; i < n; ++i) {
            if (maxDomSize < VARS[i].getDomainSize()) {
                maxDomSize = VARS[i].getDomainSize();
                idx = i;
            }
            if ((VARS[i].getTypeAndKind() & 0xF8) != 24) continue;
            ++nbBools;
        }
        if (idx != -1 && nbBools != VARS.length) {
            IntVar[] VARS2 = (IntVar[])VARS.clone();
            int[] COEFFS2 = (int[])COEFFS.clone();
            VARS2[idx] = SCALAR;
            COEFFS2[idx] = -SCALAR_COEF;
            return ScalarFactory.makeScalar(VARS2, COEFFS2, VARS[idx], -COEFFS[idx]);
        }
        if (IntConstraintFactory.tupleIt(VARS) && SCALAR.hasEnumeratedDomain()) {
            return IntConstraintFactory.table(ArrayUtils.append(VARS, {SCALAR}), TuplesFactory.scalar(VARS, COEFFS, SCALAR, SCALAR_COEF), "");
        }
        return new Scalar(VARS, COEFFS, SCALAR, SCALAR_COEF);
    }
}

