/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class IntEqRealConstraint
extends Constraint {
    public IntEqRealConstraint(IntVar[] intVars, RealVar[] realVars, double epsilon) {
        super("IntEqReal", new PropIntEqReal(intVars, realVars, epsilon));
    }

    public IntEqRealConstraint(IntVar intVar, RealVar realVar, double epsilon) {
        this(new IntVar[]{intVar}, new RealVar[]{realVar}, epsilon);
    }

    private static class PropIntEqReal
    extends Propagator<Variable> {
        int n;
        IntVar[] intVars;
        RealVar[] realVars;
        double epsilon;

        public PropIntEqReal(IntVar[] intVars, RealVar[] realVars, double epsilon) {
            super(ArrayUtils.append(intVars, realVars), PropagatorPriority.LINEAR, false);
            this.n = intVars.length;
            this.intVars = intVars;
            this.realVars = realVars;
            this.epsilon = epsilon;
            assert (this.n == realVars.length);
        }

        @Override
        public void propagate(int evtmask) throws ContradictionException {
            for (int i = 0; i < this.n; ++i) {
                IntVar intVar = this.intVars[i];
                RealVar realVar = this.realVars[i];
                realVar.updateBounds((double)intVar.getLB() - this.epsilon, (double)intVar.getUB() + this.epsilon, this.aCause);
                intVar.updateLowerBound((int)Math.ceil(realVar.getLB() - this.epsilon), this.aCause);
                intVar.updateUpperBound((int)Math.floor(realVar.getUB() + this.epsilon), this.aCause);
                if (!intVar.hasEnumeratedDomain()) continue;
                realVar.updateBounds((double)intVar.getLB() - this.epsilon, (double)intVar.getUB() + this.epsilon, this.aCause);
            }
        }

        @Override
        public ESat isEntailed() {
            assert (this.intVars.length == this.realVars.length);
            boolean allInst = true;
            for (int i = 0; i < this.n; ++i) {
                IntVar intVar = this.intVars[i];
                RealVar realVar = this.realVars[i];
                if (realVar.getLB() < (double)intVar.getLB() - this.epsilon || realVar.getUB() > (double)intVar.getUB() + this.epsilon) {
                    return ESat.FALSE;
                }
                if (intVar.isInstantiated() && realVar.isInstantiated()) continue;
                allInst = false;
            }
            return allInst ? ESat.TRUE : ESat.UNDEFINED;
        }

        @Override
        public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
            if (!identitymap.containsKey(this)) {
                int size = this.n;
                IntVar[] iVars = new IntVar[size];
                for (int i = 0; i < size; ++i) {
                    this.vars[i].duplicate(solver, identitymap);
                    iVars[i] = (IntVar)identitymap.get(this.vars[i]);
                }
                RealVar[] rVars = new RealVar[size];
                for (int i = 0; i < size; ++i) {
                    this.vars[i + this.n].duplicate(solver, identitymap);
                    rVars[i] = (RealVar)identitymap.get(this.vars[i + this.n]);
                }
                identitymap.put(this, new PropIntEqReal(iVars, rVars, this.epsilon));
            }
        }
    }
}

