/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.real.Ibex;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.util.ESat;

public class RealPropagator
extends Propagator<RealVar> {
    final Ibex ibex;
    final String functions;
    final int option;
    final int contractorIdx;

    public RealPropagator(String functions, RealVar[] vars, int options) {
        super((Variable[])vars, PropagatorPriority.LINEAR, false);
        this.ibex = this.solver.getIbex();
        this.functions = functions;
        this.option = options;
        this.contractorIdx = this.ibex.add_contractor(vars.length, functions, this.option);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return RealEventType.BOUND.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        double[] domains = new double[2 * ((RealVar[])this.vars).length];
        for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
            domains[2 * i] = ((RealVar[])this.vars)[i].getLB();
            domains[2 * i + 1] = ((RealVar[])this.vars)[i].getUB();
        }
        int result = this.ibex.contract(this.contractorIdx, domains);
        switch (result) {
            case 0: {
                this.contradiction(null, "Ibex failed");
            }
            case 2: {
                for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
                    ((RealVar[])this.vars)[i].updateBounds(domains[2 * i], domains[2 * i + 1], this.aCause);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
                    ((RealVar[])this.vars)[i].updateBounds(domains[2 * i], domains[2 * i + 1], this.aCause);
                }
                this.setPassive();
                break;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        double[] domains = new double[2 * ((RealVar[])this.vars).length];
        for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
            domains[2 * i] = ((RealVar[])this.vars)[i].getLB();
            domains[2 * i + 1] = ((RealVar[])this.vars)[i].getUB();
        }
        int result = this.ibex.contract(this.contractorIdx, domains);
        if (result == 0) {
            return ESat.FALSE;
        }
        if (result == 1 || this.isCompletelyInstantiated()) {
            for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
                if (!(((RealVar[])this.vars)[i].getLB() < domains[2 * i]) && !(((RealVar[])this.vars)[i].getUB() > domains[2 * i + 1])) continue;
                return ESat.UNDEFINED;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((RealVar[])this.vars).length;
            RealVar[] rvars = new RealVar[size];
            for (int i = 0; i < size; ++i) {
                ((RealVar[])this.vars)[i].duplicate(solver, identitymap);
                rvars[i] = (RealVar)identitymap.get(((RealVar[])this.vars)[i]);
            }
            identitymap.put(this, new RealPropagator(this.functions, rvars, this.option));
        }
    }
}

