/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.ReificationConstraint;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropReif
extends Propagator<Variable> {
    private final BoolVar bVar;
    private final Constraint trueCons;
    private final Constraint falseCons;
    private ReificationConstraint reifCons;

    public PropReif(Variable[] allVars, Constraint consIfBoolTrue, Constraint consIfBoolFalse) {
        super(allVars, PropReif.computePrority(consIfBoolTrue, consIfBoolFalse), false);
        this.bVar = (BoolVar)this.vars[0];
        this.trueCons = consIfBoolTrue;
        this.falseCons = consIfBoolFalse;
    }

    public void setReifCons(ReificationConstraint reifCons) {
        assert (this.reifCons == null) : "cannot change the ReificationConstraint of a PropReif";
        this.reifCons = reifCons;
    }

    private static PropagatorPriority computePrority(Constraint consIfBoolTrue, Constraint consIfBoolFalse) {
        int p = Math.min(consIfBoolTrue.computeMaxPriority().priority, consIfBoolFalse.computeMaxPriority().priority);
        return PropagatorPriority.get(Math.min(p, PropagatorPriority.TERNARY.priority));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.bVar.isInstantiated()) {
            this.setPassive();
            if (this.bVar.getBooleanValue() == ESat.TRUE) {
                this.reifCons.activate(0);
            } else {
                this.reifCons.activate(1);
            }
        } else {
            ESat sat = this.trueCons.isSatisfied();
            if (sat == ESat.TRUE) {
                this.setPassive();
                this.bVar.setToTrue(this.aCause);
                this.reifCons.activate(0);
            } else if (sat == ESat.FALSE) {
                this.setPassive();
                this.bVar.setToFalse(this.aCause);
                this.reifCons.activate(1);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        ESat fie;
        if (this.bVar.isInstantiated()) {
            if (this.bVar.getValue() == 1) {
                return this.trueCons.isSatisfied();
            }
            return this.falseCons.isSatisfied();
        }
        ESat tie = this.trueCons.isSatisfied();
        if (tie != ESat.UNDEFINED && tie == (fie = this.falseCons.isSatisfied())) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        if (d.getVar() == this.bVar) {
            for (Variable v : this.vars) {
                v.explain(xengine, VariableState.DOM, e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public String toString() {
        return this.bVar.toString() + "=>" + this.trueCons.toString() + ", !" + this.bVar.toString() + "=>" + this.falseCons.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        throw new SolverException("PropReif cannot be duplicated!");
    }
}

