/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropAllDiff
extends Propagator<SetVar> {
    private int n;

    public PropAllDiff(SetVar[] sets) {
        super((Variable[])sets, PropagatorPriority.LINEAR, true);
        this.n = sets.length;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) continue;
            this.propagate(i, 0);
        }
    }

    @Override
    public void propagate(int idx, int mask) throws ContradictionException {
        if (((SetVar[])this.vars)[idx].isInstantiated()) {
            int s = ((SetVar[])this.vars)[idx].getEnvelopeSize();
            for (int i = 0; i < this.n; ++i) {
                if (i == idx) continue;
                int sei = ((SetVar[])this.vars)[i].getEnvelopeSize();
                int ski = ((SetVar[])this.vars)[i].getKernelSize();
                if (ski < s - 1 || sei > s + 1) continue;
                int nbSameInKer = 0;
                int diff = -1;
                int j = ((SetVar[])this.vars)[idx].getKernelFirst();
                while (j != Integer.MIN_VALUE) {
                    if (((SetVar[])this.vars)[i].kernelContains(j)) {
                        ++nbSameInKer;
                    } else {
                        diff = j;
                    }
                    j = ((SetVar[])this.vars)[idx].getKernelNext();
                }
                if (nbSameInKer == s) {
                    if (sei == s) {
                        this.contradiction(((SetVar[])this.vars)[i], "");
                        continue;
                    }
                    if (sei != s + 1 || ski >= sei) continue;
                    j = ((SetVar[])this.vars)[i].getEnvelopeFirst();
                    while (j != Integer.MIN_VALUE) {
                        ((SetVar[])this.vars)[i].addToKernel(j, this.aCause);
                        j = ((SetVar[])this.vars)[i].getEnvelopeNext();
                    }
                    continue;
                }
                if (sei != s || nbSameInKer != s - 1 || !((SetVar[])this.vars)[i].envelopeContains(diff)) continue;
                ((SetVar[])this.vars)[i].removeFromEnvelope(diff, this.aCause);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) {
                return ESat.UNDEFINED;
            }
            for (int i2 = i + 1; i2 < this.n; ++i2) {
                if (!this.same(i, i2)) continue;
                return ESat.FALSE;
            }
        }
        return ESat.TRUE;
    }

    private boolean same(int i, int i2) {
        if (((SetVar[])this.vars)[i].getEnvelopeSize() < ((SetVar[])this.vars)[i2].getKernelSize()) {
            return false;
        }
        if (((SetVar[])this.vars)[i2].getEnvelopeSize() < ((SetVar[])this.vars)[i].getKernelSize()) {
            return false;
        }
        if (((SetVar[])this.vars)[i].isInstantiated() && ((SetVar[])this.vars)[i2].isInstantiated()) {
            int j = ((SetVar[])this.vars)[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                if (!((SetVar[])this.vars)[i2].envelopeContains(j)) {
                    return false;
                }
                j = ((SetVar[])this.vars)[i].getKernelNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((SetVar[])this.vars).length;
            SetVar[] aVars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                ((SetVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (SetVar)identitymap.get(((SetVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropAllDiff(aVars));
        }
    }
}

