/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;

public class PropAllDisjoint
extends Propagator<SetVar> {
    private int n;
    private int currentSet;
    private ISetDeltaMonitor[] sdm;
    private IntProcedure elementForced;

    public PropAllDisjoint(SetVar[] sets) {
        super((Variable[])sets, PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.sdm = new ISetDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> {
            for (int i = 0; i < this.n; ++i) {
                if (i == this.currentSet) continue;
                ((SetVar[])this.vars)[i].removeFromEnvelope(element, this.aCause);
            }
        };
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return SetEventType.ADD_TO_KER.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < this.n; ++i) {
                int j = ((SetVar[])this.vars)[i].getKernelFirst();
                while (j != Integer.MIN_VALUE) {
                    for (int i2 = 0; i2 < this.n; ++i2) {
                        if (i2 == i) continue;
                        ((SetVar[])this.vars)[i2].removeFromEnvelope(j, this.aCause);
                    }
                    j = ((SetVar[])this.vars)[i].getKernelNext();
                }
            }
        }
        for (i = 0; i < this.n; ++i) {
            this.sdm[i].unfreeze();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.currentSet = idxVarInProp;
        this.sdm[this.currentSet].freeze();
        this.sdm[this.currentSet].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[this.currentSet].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        boolean allInstantiated = true;
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) {
                allInstantiated = false;
            }
            int j = ((SetVar[])this.vars)[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    if (i2 == i || !((SetVar[])this.vars)[i2].kernelContains(j)) continue;
                    return ESat.FALSE;
                }
                j = ((SetVar[])this.vars)[i].getKernelNext();
            }
        }
        if (allInstantiated) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((SetVar[])this.vars).length;
            SetVar[] aVars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                ((SetVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (SetVar)identitymap.get(((SetVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropAllDisjoint(aVars));
        }
    }
}

