/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;

public class PropAtMost1Empty
extends Propagator<SetVar> {
    private IStateInt emptySetIndex;

    public PropAtMost1Empty(SetVar[] sets) {
        super((Variable[])sets, PropagatorPriority.UNARY, true);
        this.emptySetIndex = this.solver.getEnvironment().makeInt(-1);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            this.propagate(i, 0);
        }
    }

    @Override
    public void propagate(int v, int mask) throws ContradictionException {
        if (((SetVar[])this.vars)[v].getEnvelopeSize() == 0) {
            if (this.emptySetIndex.get() != -1) {
                this.contradiction(((SetVar[])this.vars)[v], "");
            } else {
                this.emptySetIndex.set(v);
                for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
                    int s = ((SetVar[])this.vars)[i].getEnvelopeSize();
                    if (i == v || s == ((SetVar[])this.vars)[i].getKernelSize()) continue;
                    if (s == 0) {
                        this.contradiction(((SetVar[])this.vars)[i], "");
                        continue;
                    }
                    if (s != 1) continue;
                    ((SetVar[])this.vars)[i].addToKernel(((SetVar[])this.vars)[i].getEnvelopeFirst(), this.aCause);
                }
            }
        }
        if (((SetVar[])this.vars)[v].getEnvelopeSize() == 1 && this.emptySetIndex.get() != -1) {
            ((SetVar[])this.vars)[v].addToKernel(((SetVar[])this.vars)[v].getEnvelopeFirst(), this.aCause);
        }
    }

    @Override
    public ESat isEntailed() {
        boolean none = true;
        boolean allInstantiated = true;
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            if (((SetVar[])this.vars)[i].getEnvelopeSize() == 0) {
                if (!none) {
                    return ESat.FALSE;
                }
                none = false;
                continue;
            }
            if (((SetVar[])this.vars)[i].isInstantiated()) continue;
            allInstantiated = false;
        }
        if (allInstantiated) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((SetVar[])this.vars).length;
            SetVar[] aVars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                ((SetVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (SetVar)identitymap.get(((SetVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropAtMost1Empty(aVars));
        }
    }
}

